/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.rvadapter;

import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.google.android.agera.Binder;
import com.google.android.agera.Binders;
import com.google.android.agera.Function;
import com.google.android.agera.Functions;
import com.google.android.agera.Preconditions;
import com.google.android.agera.Receiver;
import com.google.android.agera.Receivers;
import com.google.android.agera.Result;
import com.google.android.agera.rvadapter.RepositoryPresenter;
import com.google.android.agera.rvadapter.RepositoryPresenterCompilerStates;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

final class RepositoryPresenterCompiler
implements RepositoryPresenterCompilerStates.RPLayout,
RepositoryPresenterCompilerStates.RPMain,
RepositoryPresenterCompilerStates.RPItemCompile,
RepositoryPresenterCompilerStates.RPTypedCollectionCompile {
    @NonNull
    private static final Function<Object, Object> NO_KEY_FOR_ITEM = Functions.identityFunction();
    @NonNull
    private static final Function<Object, Object> SAME_KEY_FOR_ITEM = Functions.staticFunction((Object)new Object());
    @NonNull
    private Function<Object, Integer> layoutForItem;
    @NonNull
    private Binder binder = Binders.nullBinder();
    @NonNull
    private Receiver recycler = Receivers.nullReceiver();
    @NonNull
    private Function<Object, Long> stableIdForItem = Functions.staticFunction((Object)-1L);
    @NonNull
    private Function<Object, Object> keyForItem = NO_KEY_FOR_ITEM;
    private boolean detectMoves;
    @NonNull
    private Binder collectionBinder = Binders.nullBinder();

    RepositoryPresenterCompiler() {
    }

    @NonNull
    public RepositoryPresenter forItem() {
        return new CompiledRepositoryPresenter(this.layoutForItem, (Binder<Object, View>)this.binder, this.stableIdForItem, (Receiver<View>)this.recycler, this.keyForItem, this.detectMoves, (Function<Object, List<Object>>)Functions.itemAsList(), (Binder<Object, View>)this.collectionBinder);
    }

    @NonNull
    public RepositoryPresenter<List> forList() {
        return new CompiledRepositoryPresenter(this.layoutForItem, (Binder<Object, View>)this.binder, this.stableIdForItem, (Receiver<View>)this.recycler, this.keyForItem, this.detectMoves, (Function<Object, List<Object>>)Functions.identityFunction(), (Binder<Object, View>)this.collectionBinder);
    }

    @NonNull
    public RepositoryPresenter<Result> forResult() {
        return new CompiledRepositoryPresenter(this.layoutForItem, (Binder<Object, View>)this.binder, this.stableIdForItem, (Receiver<View>)this.recycler, this.keyForItem, this.detectMoves, (Function<Object, List<Object>>)Functions.resultAsList(), (Binder<Object, View>)this.collectionBinder);
    }

    @NonNull
    public RepositoryPresenter<Result<List>> forResultList() {
        return new CompiledRepositoryPresenter(this.layoutForItem, (Binder<Object, View>)this.binder, this.stableIdForItem, (Receiver<View>)this.recycler, this.keyForItem, this.detectMoves, (Function<Object, List<Object>>)Functions.resultListAsList(), (Binder<Object, View>)this.collectionBinder);
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPTypedCollectionCompile bindCollectionWith(@NonNull Binder collectionBinder) {
        this.collectionBinder = collectionBinder;
        return this;
    }

    @NonNull
    public RepositoryPresenter forCollection(@NonNull Function converter) {
        return new CompiledRepositoryPresenter(this.layoutForItem, (Binder<Object, View>)this.binder, this.stableIdForItem, (Receiver<View>)this.recycler, this.keyForItem, this.detectMoves, (Function<Object, List<Object>>)converter, (Binder<Object, View>)this.collectionBinder);
    }

    @NonNull
    public Object layout(@LayoutRes int layoutId) {
        this.layoutForItem = Functions.staticFunction((Object)layoutId);
        return this;
    }

    @NonNull
    public Object layoutForItem(@NonNull Function layoutForItem) {
        this.layoutForItem = (Function)Preconditions.checkNotNull((Object)layoutForItem);
        return this;
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPMain bindWith(@NonNull Binder binder) {
        this.binder = binder;
        return this;
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPMain stableIdForItem(@NonNull Function stableIdForItem) {
        this.stableIdForItem = stableIdForItem;
        return this;
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPItemCompile stableId(long stableId) {
        this.stableIdForItem(Functions.staticFunction((Object)stableId));
        return this;
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPMain recycleWith(@NonNull Receiver recycler) {
        this.recycler = recycler;
        return this;
    }

    @Override
    @NonNull
    public RepositoryPresenterCompilerStates.RPMain diffWith(@NonNull Function keyForItem, boolean detectMoves) {
        this.keyForItem = keyForItem;
        this.detectMoves = detectMoves;
        return this;
    }

    @NonNull
    public RepositoryPresenterCompilerStates.RPItemCompile diff() {
        this.keyForItem = SAME_KEY_FOR_ITEM;
        this.detectMoves = false;
        return this;
    }

    private static final class CompiledRepositoryPresenter
    extends RepositoryPresenter {
        @NonNull
        private final Function<Object, List<Object>> converter;
        @NonNull
        private final Binder<Object, View> collectionBinder;
        @NonNull
        private final Function<Object, Integer> layoutId;
        @NonNull
        private final Binder<Object, View> binder;
        @NonNull
        private final Function<Object, Long> stableIdForItem;
        @NonNull
        private final Receiver<View> recycler;
        private final boolean enableDiff;
        @NonNull
        private final Function<Object, Object> keyForItem;
        private final boolean detectMoves;
        @NonNull
        private WeakReference<Object> dataRef = new WeakReference<Object>(null);
        @NonNull
        private List items = Collections.emptyList();

        CompiledRepositoryPresenter(@NonNull Function<Object, Integer> layoutId, @NonNull Binder<Object, View> binder, @NonNull Function<Object, Long> stableIdForItem, @NonNull Receiver<View> recycler, @NonNull Function<Object, Object> keyForItem, boolean detectMoves, @NonNull Function<Object, List<Object>> converter, @NonNull Binder<Object, View> collectionBinder) {
            this.collectionBinder = collectionBinder;
            this.converter = converter;
            this.layoutId = layoutId;
            this.binder = binder;
            this.stableIdForItem = stableIdForItem;
            this.recycler = recycler;
            this.enableDiff = keyForItem != NO_KEY_FOR_ITEM;
            this.keyForItem = keyForItem;
            this.detectMoves = detectMoves;
        }

        public int getItemCount(@NonNull Object data) {
            return this.getItems(data).size();
        }

        public int getLayoutResId(@NonNull Object data, int index) {
            return (Integer)this.layoutId.apply(this.getItems(data).get(index));
        }

        public void bind(@NonNull Object data, int index, @NonNull RecyclerView.ViewHolder holder) {
            Object item = this.getItems(data).get(index);
            View view = holder.itemView;
            this.bind(data, item, view);
        }

        protected void bind(@NonNull Object data, @NonNull Object item, @NonNull View view) {
            this.collectionBinder.bind(data, (Object)view);
            this.binder.bind(item, (Object)view);
        }

        @Override
        public void recycle(@NonNull RecyclerView.ViewHolder holder) {
            this.recycler.accept((Object)holder.itemView);
        }

        public long getItemId(@NonNull Object data, int index) {
            return (Long)this.stableIdForItem.apply(this.getItems(data).get(index));
        }

        @NonNull
        private List getItems(@NonNull Object data) {
            if (this.dataRef.get() != data) {
                this.items = (List)this.converter.apply(data);
                this.dataRef = new WeakReference<Object>(data);
            }
            return this.items;
        }

        public boolean getUpdates(@NonNull Object oldData, @NonNull Object newData, @NonNull ListUpdateCallback listUpdateCallback) {
            if (!this.enableDiff) {
                return false;
            }
            if (oldData == newData) {
                int itemCount = this.getItemCount(oldData);
                listUpdateCallback.onChanged(0, itemCount, null);
                return true;
            }
            final List oldItems = this.getItems(oldData);
            final List newItems = this.getItems(newData);
            DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback(){

                public int getOldListSize() {
                    return oldItems.size();
                }

                public int getNewListSize() {
                    return newItems.size();
                }

                public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                    Object oldKey = CompiledRepositoryPresenter.this.keyForItem.apply(oldItems.get(oldItemPosition));
                    Object newKey = CompiledRepositoryPresenter.this.keyForItem.apply(newItems.get(newItemPosition));
                    return oldKey.equals(newKey);
                }

                public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                    Object oldItem = oldItems.get(oldItemPosition);
                    Object newItem = newItems.get(newItemPosition);
                    return oldItem.equals(newItem);
                }
            }, (boolean)this.detectMoves).dispatchUpdatesTo(listUpdateCallback);
            return true;
        }
    }
}

