/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.rvadapter;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.ListUpdateCallback;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.google.android.agera.Observable;
import com.google.android.agera.Observables;
import com.google.android.agera.Preconditions;
import com.google.android.agera.Repository;
import com.google.android.agera.Updatable;
import com.google.android.agera.rvadapter.LayoutPresenter;
import com.google.android.agera.rvadapter.RepositoryAdapter;
import com.google.android.agera.rvadapter.RepositoryPresenter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class RepositoryAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements Updatable {
    private final int partCount;
    private final int staticItemCount;
    @NonNull
    private final Part[] parts;
    @NonNull
    private final Map<RecyclerView.ViewHolder, Part> partForViewHolder;
    @NonNull
    private final Observable additionalObservables;
    @NonNull
    private final int[] endPositions;
    private boolean dataInvalid;
    private int resolvedPartIndex;
    private int resolvedItemIndex;

    @NonNull
    public static Builder repositoryAdapter() {
        return new Builder();
    }

    public RepositoryAdapter(@NonNull Builder builder) {
        int partCount = builder.parts.size();
        Preconditions.checkArgument((partCount > 0 ? 1 : 0) != 0, (String)"Must add at least one part");
        this.partCount = partCount;
        this.staticItemCount = builder.staticItemCount;
        this.parts = new Part[partCount];
        for (int i = 0; i < partCount; ++i) {
            Part part;
            this.parts[i] = part = builder.parts.get(i);
            part.attach(this, i);
        }
        this.partForViewHolder = new IdentityHashMap<RecyclerView.ViewHolder, Part>();
        this.additionalObservables = Observables.compositeObservable((Observable[])builder.additionalObservables.toArray(new Observable[builder.additionalObservables.size()]));
        this.endPositions = new int[partCount];
        this.dataInvalid = true;
        builder.parts.clear();
        builder.additionalObservables.clear();
        builder.staticItemCount = 0;
    }

    public final void startObserving() {
        this.additionalObservables.addUpdatable((Updatable)this);
        for (Part part : this.parts) {
            part.startObserving();
        }
    }

    public final void stopObserving() {
        this.additionalObservables.removeUpdatable((Updatable)this);
        for (Part part : this.parts) {
            part.stopObserving();
        }
    }

    public final void update() {
        this.updateAllParts();
    }

    public final int getItemCount() {
        if (this.dataInvalid) {
            this.reloadAllData();
            this.dataInvalid = false;
        }
        return this.endPositions[this.partCount - 1];
    }

    private void reloadAllData() {
        int lastEndPosition = 0;
        for (int i = 0; i < this.partCount; ++i) {
            this.endPositions[i] = lastEndPosition += this.parts[i].getItemCount();
        }
    }

    public final int getItemViewType(int position) {
        this.resolveIndices(position);
        return this.parts[this.resolvedPartIndex].getLayoutResId(this.resolvedItemIndex);
    }

    public final long getItemId(int position) {
        this.resolveIndices(position);
        return this.parts[this.resolvedPartIndex].getItemId(this.resolvedItemIndex, this.staticItemCount);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int layoutResourceId) {
        return new RecyclerView.ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(layoutResourceId, parent, false)){};
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.resolveIndices(position);
        Part part = this.parts[this.resolvedPartIndex];
        this.partForViewHolder.put(holder, part);
        part.bind(this.resolvedItemIndex, holder);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        this.recycle(holder);
        return super.onFailedToRecycleView(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        this.recycle(holder);
    }

    private void recycle(@NonNull RecyclerView.ViewHolder holder) {
        Part part = this.partForViewHolder.remove(holder);
        if (part != null) {
            part.recycle(holder);
        }
    }

    private void resolveIndices(int position) {
        int itemCount = this.getItemCount();
        if (position < 0 || position >= itemCount) {
            throw new IndexOutOfBoundsException("Asked for position " + position + " while count is " + itemCount);
        }
        int arrayIndex = Arrays.binarySearch(this.endPositions, position);
        if (arrayIndex >= 0) {
            while (this.endPositions[++arrayIndex] == position) {
            }
        } else {
            arrayIndex ^= 0xFFFFFFFF;
        }
        this.resolvedPartIndex = arrayIndex;
        this.resolvedItemIndex = arrayIndex == 0 ? position : position - this.endPositions[arrayIndex - 1];
    }

    private void updateAllParts() {
        if (this.dataInvalid) {
            return;
        }
        if (!this.hasObservers()) {
            this.reloadAllData();
            return;
        }
        int lastEndPosition = 0;
        int nextPartItemCount = this.endPositions[0];
        ListUpdateRecorder recorder = ListUpdateRecorder.obtain(0);
        for (int i = 0; i < this.partCount; ++i) {
            recorder.nextPart(nextPartItemCount);
            if (this.parts[i].getUpdates(false, recorder)) {
                lastEndPosition = recorder.commitCurrentEndPosition();
                if (i + 1 < this.partCount) {
                    nextPartItemCount = this.endPositions[i + 1] - this.endPositions[i];
                }
            } else {
                this.dataInvalid = true;
                this.notifyDataSetChanged();
                recorder.recycle();
                return;
            }
            this.endPositions[i] = lastEndPosition;
        }
        recorder.replayAndRecycle(this);
    }

    private void updateOnePart(@NonNull RepositoryPart part, int partIndex) {
        Preconditions.checkState((partIndex < this.partCount && part == this.parts[partIndex] ? 1 : 0) != 0, (String)"Wrong RA-part connection");
        if (this.dataInvalid) {
            return;
        }
        int previousPartEndPosition = partIndex == 0 ? 0 : this.endPositions[partIndex - 1];
        int oldEndPosition = this.endPositions[partIndex];
        if (!this.hasObservers()) {
            int oldCount = oldEndPosition - previousPartEndPosition;
            int newCount = part.getItemCount();
            this.offsetEndPositionsFrom(partIndex, newCount - oldCount);
            return;
        }
        ListUpdateRecorder recorder = ListUpdateRecorder.obtain(previousPartEndPosition);
        recorder.nextPart(oldEndPosition - previousPartEndPosition);
        if (part.getUpdates(true, recorder)) {
            int newEndPosition;
            this.endPositions[partIndex] = newEndPosition = recorder.commitCurrentEndPosition();
            this.offsetEndPositionsFrom(partIndex + 1, newEndPosition - oldEndPosition);
            recorder.replayAndRecycle(this);
        } else {
            this.dataInvalid = true;
            this.notifyDataSetChanged();
            recorder.recycle();
        }
    }

    private void offsetEndPositionsFrom(int partIndex, int offset) {
        int i = partIndex;
        while (i < this.partCount) {
            int n = i++;
            this.endPositions[n] = this.endPositions[n] + offset;
        }
    }

    private static final class ListUpdateRecorder
    implements ListUpdateCallback {
        @Nullable
        private static ListUpdateRecorder recycledInstance;
        @NonNull
        private final List<ListUpdateRecord> recordList = new ArrayList<ListUpdateRecord>();
        private int recordCount;
        private int positionOffset;
        private int itemCount;

        private ListUpdateRecorder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        static ListUpdateRecorder obtain(int startingPositionOffset) {
            Class<ListUpdateRecorder> clazz = ListUpdateRecorder.class;
            synchronized (ListUpdateRecorder.class) {
                ListUpdateRecorder localInstance = recycledInstance;
                recycledInstance = null;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                if (localInstance == null) {
                    localInstance = new ListUpdateRecorder();
                }
                localInstance.positionOffset = startingPositionOffset;
                return localInstance;
            }
        }

        void nextPart(int oldItemCount) {
            this.itemCount = oldItemCount;
        }

        private ListUpdateRecord nextRecord() {
            Preconditions.checkState((this.positionOffset != -1 ? 1 : 0) != 0, (String)"Illegal call to ListUpdateCallback");
            int index = this.recordCount++;
            if (this.recordList.size() > index) {
                return this.recordList.get(index);
            }
            ListUpdateRecord record = new ListUpdateRecord();
            this.recordList.add(record);
            return record;
        }

        public void onInserted(int position, int count) {
            Preconditions.checkArgument((0 <= position && position <= this.itemCount ? 1 : 0) != 0, (String)"onInserted: invalid position");
            Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (String)"onInserted: invalid count");
            ListUpdateRecord record = this.nextRecord();
            record.action = 1;
            record.position = this.positionOffset + position;
            record.secondParam = count;
            record.payload = null;
            this.itemCount += count;
        }

        public void onRemoved(int position, int count) {
            Preconditions.checkArgument((0 <= position && position < this.itemCount ? 1 : 0) != 0, (String)"onRemoved: invalid position");
            Preconditions.checkArgument((count >= 0 && position + count <= this.itemCount ? 1 : 0) != 0, (String)"onRemoved: invalid count");
            ListUpdateRecord record = this.nextRecord();
            record.action = 2;
            record.position = this.positionOffset + position;
            record.secondParam = count;
            record.payload = null;
            this.itemCount -= count;
        }

        public void onMoved(int fromPosition, int toPosition) {
            Preconditions.checkArgument((0 <= fromPosition && fromPosition < this.itemCount ? 1 : 0) != 0, (String)"onMoved: invalid fromPosition");
            Preconditions.checkArgument((0 <= toPosition && toPosition < this.itemCount ? 1 : 0) != 0, (String)"onMoved: invalid toPosition");
            ListUpdateRecord record = this.nextRecord();
            record.action = 3;
            record.position = this.positionOffset + fromPosition;
            record.secondParam = this.positionOffset + toPosition;
            record.payload = null;
        }

        public void onChanged(int position, int count, Object payload) {
            Preconditions.checkArgument((0 <= position && position < this.itemCount ? 1 : 0) != 0, (String)"onChanged: invalid position");
            Preconditions.checkArgument((count >= 0 && position + count <= this.itemCount ? 1 : 0) != 0, (String)"onChanged: invalid count");
            ListUpdateRecord record = this.nextRecord();
            record.action = 4;
            record.position = this.positionOffset + position;
            record.secondParam = count;
            record.payload = payload;
        }

        int commitCurrentEndPosition() {
            int lastEndPosition;
            this.positionOffset = lastEndPosition = this.positionOffset + this.itemCount;
            return lastEndPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.recordCount = 0;
            this.positionOffset = -1;
            this.itemCount = 0;
            Class<ListUpdateRecorder> clazz = ListUpdateRecorder.class;
            synchronized (ListUpdateRecorder.class) {
                recycledInstance = this;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        void replayAndRecycle(@NonNull RepositoryAdapter adapter) {
            block6: for (int i = 0; i < this.recordCount; ++i) {
                ListUpdateRecord record = this.recordList.get(i);
                switch (record.action) {
                    case 1: {
                        adapter.notifyItemRangeInserted(record.position, record.secondParam);
                        continue block6;
                    }
                    case 2: {
                        adapter.notifyItemRangeRemoved(record.position, record.secondParam);
                        continue block6;
                    }
                    case 3: {
                        adapter.notifyItemMoved(record.position, record.secondParam);
                        continue block6;
                    }
                    case 4: {
                        adapter.notifyItemRangeChanged(record.position, record.secondParam, record.payload);
                    }
                }
            }
            this.recycle();
        }
    }

    private static final class ListUpdateRecord {
        @ListUpdateAction
        int action;
        int position;
        int secondParam;
        Object payload;

        private ListUpdateRecord() {
        }
    }

    private static final class LayoutPart
    extends Part {
        private final long itemId;
        @NonNull
        private final LayoutPresenter presenter;

        private LayoutPart(long itemId, @NonNull LayoutPresenter presenter) {
            this.itemId = itemId;
            this.presenter = presenter;
        }

        @Override
        int getItemCount() {
            return 1;
        }

        @Override
        long getItemId(int index, long staticItemCount) {
            return this.itemId;
        }

        @Override
        int getLayoutResId(int index) {
            return this.presenter.getLayoutResId();
        }

        @Override
        void bind(int index, @NonNull RecyclerView.ViewHolder holder) {
            this.presenter.bind(holder.itemView);
        }

        @Override
        void recycle(@NonNull RecyclerView.ViewHolder holder) {
            this.presenter.recycle(holder.itemView);
        }
    }

    private static final class ItemPart
    extends Part {
        private final long itemIdOffset;
        private final int itemCount;
        @NonNull
        private final Object item;
        @NonNull
        private final RepositoryPresenter presenter;

        private ItemPart(long itemIdOffset, int itemCount, @NonNull Object item, @NonNull RepositoryPresenter presenter) {
            this.itemIdOffset = itemIdOffset;
            this.itemCount = itemCount;
            this.item = item;
            this.presenter = presenter;
        }

        @Override
        int getItemCount() {
            return this.itemCount;
        }

        @Override
        long getItemId(int index, long staticItemCount) {
            return this.itemIdOffset + (long)index;
        }

        @Override
        int getLayoutResId(int index) {
            return this.presenter.getLayoutResId(this.item, index);
        }

        @Override
        void bind(int index, @NonNull RecyclerView.ViewHolder holder) {
            this.presenter.bind(this.item, index, holder);
        }

        @Override
        void recycle(@NonNull RecyclerView.ViewHolder holder) {
            this.presenter.recycle(holder);
        }
    }

    private static final class RepositoryPart
    extends Part
    implements Updatable {
        @NonNull
        private final Repository repository;
        @NonNull
        private final RepositoryPresenter presenter;
        @NonNull
        private Object data;
        private RepositoryAdapter host;
        private int partIndex;

        private RepositoryPart(@NonNull Repository repository, @NonNull RepositoryPresenter presenter) {
            this.repository = repository;
            this.presenter = presenter;
            this.data = repository.get();
        }

        @Override
        int getItemCount() {
            this.data = this.repository.get();
            return this.presenter.getItemCount(this.data);
        }

        @Override
        long getItemId(int index, long staticItemCount) {
            return this.presenter.getItemId(this.data, index) + staticItemCount;
        }

        @Override
        int getLayoutResId(int index) {
            return this.presenter.getLayoutResId(this.data, index);
        }

        @Override
        void bind(int index, @NonNull RecyclerView.ViewHolder holder) {
            this.presenter.bind(this.data, index, holder);
        }

        @Override
        void recycle(@NonNull RecyclerView.ViewHolder holder) {
            this.presenter.recycle(holder);
        }

        @Override
        void attach(@NonNull RepositoryAdapter host, int partIndex) {
            this.host = host;
            this.partIndex = partIndex;
        }

        @Override
        void startObserving() {
            this.repository.addUpdatable((Updatable)this);
            this.update();
        }

        @Override
        void stopObserving() {
            this.repository.removeUpdatable((Updatable)this);
        }

        public void update() {
            this.host.updateOnePart(this, this.partIndex);
        }

        @Override
        boolean getUpdates(boolean reloadData, @NonNull ListUpdateCallback listUpdateCallback) {
            Object newData;
            Object oldData = this.data;
            Object object = newData = reloadData ? this.repository.get() : oldData;
            if (this.presenter.getUpdates(oldData, newData, listUpdateCallback)) {
                this.data = newData;
                return true;
            }
            return false;
        }
    }

    private static abstract class Part {
        private Part() {
        }

        abstract int getItemCount();

        abstract long getItemId(int var1, long var2);

        @LayoutRes
        abstract int getLayoutResId(int var1);

        abstract void bind(int var1, @NonNull RecyclerView.ViewHolder var2);

        abstract void recycle(@NonNull RecyclerView.ViewHolder var1);

        void attach(@NonNull RepositoryAdapter host, int partIndex) {
        }

        void startObserving() {
        }

        void stopObserving() {
        }

        boolean getUpdates(boolean reloadData, @NonNull ListUpdateCallback listUpdateCallback) {
            return true;
        }
    }

    public static final class Builder {
        @NonNull
        final List<Part> parts = new ArrayList<Part>();
        @NonNull
        final List<Observable> additionalObservables = new ArrayList<Observable>();
        int staticItemCount = 0;

        @NonNull
        public <T> Builder add(@NonNull Repository<T> repository, @NonNull RepositoryPresenter<T> presenter) {
            this.parts.add(new RepositoryPart(repository, presenter));
            return this;
        }

        @NonNull
        public <T> Builder addItem(@NonNull T item, @NonNull RepositoryPresenter<T> presenter) {
            int thisItemCount = presenter.getItemCount(item);
            if (thisItemCount > 0) {
                this.parts.add(new ItemPart(this.staticItemCount, thisItemCount, item, presenter));
                this.staticItemCount += thisItemCount;
            }
            return this;
        }

        @NonNull
        public Builder addLayout(@NonNull LayoutPresenter presenter) {
            this.parts.add(new LayoutPart(this.staticItemCount, presenter));
            ++this.staticItemCount;
            return this;
        }

        @NonNull
        public Builder addAdditionalObservable(@NonNull Observable observable) {
            this.additionalObservables.add((Observable)Preconditions.checkNotNull((Object)observable));
            return this;
        }

        @NonNull
        public RepositoryAdapter build() {
            return new RepositoryAdapter(this);
        }

        @TargetApi(value=14)
        @NonNull
        public RecyclerView.Adapter<RecyclerView.ViewHolder> whileResumed(@NonNull Activity activity) {
            RepositoryAdapter repositoryAdapter = new RepositoryAdapter(this);
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new WhileResumedActivityLifecycleCallbacks(activity, repositoryAdapter));
            return repositoryAdapter;
        }

        @TargetApi(value=14)
        @NonNull
        public RecyclerView.Adapter<RecyclerView.ViewHolder> whileStarted(@NonNull Activity activity) {
            RepositoryAdapter repositoryAdapter = new RepositoryAdapter(this);
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new WhileStartedActivityLifecycleCallbacks(activity, repositoryAdapter));
            return repositoryAdapter;
        }

        private Builder() {
        }

        private static class WhileResumedActivityLifecycleCallbacks
        extends AdapterActivityLifecycleCallbacks {
            WhileResumedActivityLifecycleCallbacks(Activity activity, @NonNull RepositoryAdapter repositoryAdapter) {
                super(activity, repositoryAdapter);
            }

            @Override
            public void onActivityResumed(Activity anyActivity) {
                if (anyActivity == this.activity) {
                    this.repositoryAdapter.startObserving();
                }
            }

            @Override
            public void onActivityPaused(Activity anyActivity) {
                if (anyActivity == this.activity) {
                    this.repositoryAdapter.stopObserving();
                }
            }
        }

        private static class WhileStartedActivityLifecycleCallbacks
        extends AdapterActivityLifecycleCallbacks {
            WhileStartedActivityLifecycleCallbacks(Activity activity, @NonNull RepositoryAdapter repositoryAdapter) {
                super(activity, repositoryAdapter);
            }

            @Override
            public void onActivityStarted(Activity anyActivity) {
                if (anyActivity == this.activity) {
                    this.repositoryAdapter.startObserving();
                }
            }

            @Override
            public void onActivityStopped(Activity anyActivity) {
                if (anyActivity == this.activity) {
                    this.repositoryAdapter.stopObserving();
                }
            }
        }

        @TargetApi(value=14)
        private static abstract class AdapterActivityLifecycleCallbacks
        implements Application.ActivityLifecycleCallbacks {
            @NonNull
            final Activity activity;
            @NonNull
            final RepositoryAdapter repositoryAdapter;

            AdapterActivityLifecycleCallbacks(@NonNull Activity activity, @NonNull RepositoryAdapter repositoryAdapter) {
                this.activity = (Activity)Preconditions.checkNotNull((Object)activity);
                this.repositoryAdapter = repositoryAdapter;
            }

            public final void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public final void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public final void onActivityDestroyed(Activity anyActivity) {
                if (this.activity == anyActivity) {
                    this.activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                }
            }
        }
    }
}

