/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.rvadapter;

import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.agera.Receiver;
import com.google.android.agera.Receivers;
import com.google.android.agera.rvadapter.LayoutPresenter;

public final class LayoutPresenters {
    @NonNull
    public static Builder layoutPresenterFor(@LayoutRes int layoutId) {
        return new Builder(layoutId);
    }

    @NonNull
    public static LayoutPresenter layout(@LayoutRes int layoutId) {
        return new Builder(layoutId).build();
    }

    private LayoutPresenters() {
    }

    private static final class CompiledLayoutPresenter
    extends LayoutPresenter {
        @LayoutRes
        private int layoutId;
        @NonNull
        private Receiver<View> recycler;
        @NonNull
        private Receiver<View> updater;

        CompiledLayoutPresenter(@LayoutRes int layoutId, @NonNull Receiver<View> recycler, @NonNull Receiver<View> updater) {
            this.layoutId = layoutId;
            this.recycler = recycler;
            this.updater = updater;
        }

        @Override
        public int getLayoutResId() {
            return this.layoutId;
        }

        @Override
        public void bind(@NonNull View view) {
            this.updater.accept((Object)view);
        }

        @Override
        public void recycle(@NonNull View view) {
            this.recycler.accept((Object)view);
        }
    }

    public static final class Builder {
        @NonNull
        private Receiver recycler = Receivers.nullReceiver();
        @NonNull
        private Receiver<View> updater = Receivers.nullReceiver();
        @LayoutRes
        private final int layoutId;

        private Builder(@LayoutRes int layoutId) {
            this.layoutId = layoutId;
        }

        @NonNull
        public Builder bindWith(@NonNull Receiver<View> binder) {
            this.updater = binder;
            return this;
        }

        @NonNull
        public Builder recycleWith(@NonNull Receiver<View> recycler) {
            this.recycler = recycler;
            return this;
        }

        @NonNull
        public LayoutPresenter build() {
            return new CompiledLayoutPresenter(this.layoutId, (Receiver<View>)this.recycler, this.updater);
        }
    }
}

