/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.utils;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.LoopAgent;
import com.google.adk.agents.ParallelAgent;
import com.google.adk.agents.SequentialAgent;
import com.google.adk.tools.AgentTool;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.tools.ExitLoopTool;
import com.google.adk.tools.GoogleSearchTool;
import com.google.adk.tools.LoadArtifactsTool;
import com.google.adk.tools.LongRunningFunctionTool;
import com.google.adk.tools.UrlContextTool;
import com.google.adk.tools.mcp.McpToolset;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ComponentRegistry.class);
    private static volatile ComponentRegistry instance = new ComponentRegistry();
    private final Map<String, Object> registry = new ConcurrentHashMap<String, Object>();

    protected ComponentRegistry() {
        this.initializePreWiredEntries();
    }

    private void initializePreWiredEntries() {
        this.registerAdkAgentClass(LlmAgent.class);
        this.registerAdkAgentClass(LoopAgent.class);
        this.registerAdkAgentClass(ParallelAgent.class);
        this.registerAdkAgentClass(SequentialAgent.class);
        this.registerAdkToolInstance("google_search", GoogleSearchTool.INSTANCE);
        this.registerAdkToolInstance("load_artifacts", LoadArtifactsTool.INSTANCE);
        this.registerAdkToolInstance("exit_loop", ExitLoopTool.INSTANCE);
        this.registerAdkToolInstance("url_context", UrlContextTool.INSTANCE);
        this.registerAdkToolClass(AgentTool.class);
        this.registerAdkToolClass(LongRunningFunctionTool.class);
        this.registerAdkToolsetClass(McpToolset.class);
        logger.debug("Initialized base pre-wired entries in ComponentRegistry");
    }

    private void registerAdkAgentClass(Class<? extends BaseAgent> agentClass) {
        this.registry.put(agentClass.getName(), agentClass);
        this.registry.put("google.adk.agents." + agentClass.getSimpleName(), agentClass);
    }

    private void registerAdkToolInstance(String name, @Nonnull Object toolInstance) {
        this.registry.put(name, toolInstance);
        this.registry.put("google.adk.tools." + name, toolInstance);
    }

    private void registerAdkToolClass(@Nonnull Class<?> toolClass) {
        this.registry.put(toolClass.getName(), toolClass);
        this.registry.put("google.adk.tools." + toolClass.getSimpleName(), toolClass);
    }

    private void registerAdkToolsetClass(@Nonnull Class<? extends BaseToolset> toolsetClass) {
        this.registry.put(toolsetClass.getName(), toolsetClass);
        this.registry.put("google.adk.tools." + toolsetClass.getSimpleName(), toolsetClass);
        this.registry.put(toolsetClass.getSimpleName(), toolsetClass);
        String simpleName = toolsetClass.getSimpleName();
        if (simpleName.equals("McpToolset")) {
            this.registry.put("mcp.McpToolset", toolsetClass);
        }
    }

    public void register(String name, Object value) {
        if (Strings.isNullOrEmpty((String)name) || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        Object previous = this.registry.put(name, value);
        if (previous != null) {
            logger.info("Overriding existing registration for name: {} (was: {}, now: {})", new Object[]{name, previous.getClass().getSimpleName(), value.getClass().getSimpleName()});
        } else {
            logger.debug("Registered new object of type {} with name: {}", (Object)value.getClass().getSimpleName(), (Object)name);
        }
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        return this.get(name).filter(value -> {
            if (type.isInstance(value)) {
                return true;
            }
            logger.info("Object with name '{}' is of type {} but expected type {}", new Object[]{name, value.getClass().getSimpleName(), type.getSimpleName()});
            return false;
        }).map(type::cast);
    }

    public Optional<Object> get(String name) {
        return Optional.ofNullable(Strings.emptyToNull((String)name)).filter(n -> !n.trim().isEmpty()).flatMap(n -> Optional.ofNullable(this.registry.get(n)));
    }

    public static ComponentRegistry getInstance() {
        return instance;
    }

    public static synchronized void setInstance(ComponentRegistry newInstance) {
        if (newInstance == null) {
            throw new IllegalArgumentException("ComponentRegistry instance cannot be null");
        }
        instance = newInstance;
        logger.info("ComponentRegistry singleton instance updated");
    }

    public static Optional<BaseAgent> resolveAgentInstance(String name) {
        return ComponentRegistry.getInstance().get(name, BaseAgent.class);
    }

    public static Class<? extends BaseAgent> resolveAgentClass(String agentClassName) {
        if (Strings.isNullOrEmpty((String)agentClassName)) {
            return LlmAgent.class;
        }
        Optional<Class<BaseAgent>> agentClass = agentClassName.contains(".") ? ComponentRegistry.getType(agentClassName, BaseAgent.class) : ComponentRegistry.getType(agentClassName, BaseAgent.class).or(() -> ComponentRegistry.getType("com.google.adk.agents." + agentClassName, BaseAgent.class)).or(() -> ComponentRegistry.getType("google.adk.agents." + agentClassName, BaseAgent.class));
        return agentClass.orElseThrow(() -> new IllegalArgumentException("agentClass '" + agentClassName + "' is not in registry or not a subclass of BaseAgent."));
    }

    public static Optional<BaseToolset> resolveToolsetInstance(String name) {
        return ComponentRegistry.resolveInstance(name, "tools", BaseToolset.class);
    }

    public static Optional<BaseTool> resolveToolInstance(String name) {
        return ComponentRegistry.resolveInstance(name, "tools", BaseTool.class);
    }

    private static <T> Optional<T> resolveInstance(String name, String adkPackage, Class<T> type) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        if (name.contains(".")) {
            return ComponentRegistry.getInstance().get(name, type);
        }
        return ComponentRegistry.getInstance().get(name, type).or(() -> ComponentRegistry.getInstance().get(String.format("com.google.adk.%s.%s", adkPackage, name), type)).or(() -> ComponentRegistry.getInstance().get(String.format("google.adk.%s.%s", adkPackage, name), type));
    }

    public static Optional<Class<? extends BaseTool>> resolveToolClass(String toolClassName) {
        if (Strings.isNullOrEmpty((String)toolClassName)) {
            return Optional.empty();
        }
        if (toolClassName.contains(".")) {
            return ComponentRegistry.getType(toolClassName, BaseTool.class);
        }
        return ComponentRegistry.getType(toolClassName, BaseTool.class).or(() -> ComponentRegistry.getType("com.google.adk.tools." + toolClassName, BaseTool.class)).or(() -> ComponentRegistry.getType("google.adk.tools." + toolClassName, BaseTool.class));
    }

    public static Optional<Class<? extends BaseToolset>> resolveToolsetClass(String toolsetClassName) {
        if (Strings.isNullOrEmpty((String)toolsetClassName)) {
            return Optional.empty();
        }
        if (toolsetClassName.contains(".")) {
            return ComponentRegistry.getType(toolsetClassName, BaseToolset.class).or(() -> ComponentRegistry.loadToolsetClass(toolsetClassName));
        }
        return ComponentRegistry.getType(toolsetClassName, BaseToolset.class).or(() -> ComponentRegistry.getType("com.google.adk.tools." + toolsetClassName, BaseToolset.class)).or(() -> ComponentRegistry.getType("google.adk.tools." + toolsetClassName, BaseToolset.class));
    }

    public Set<String> getToolNamesWithPrefix(String prefix) {
        return (Set)this.registry.keySet().stream().filter(name -> name.startsWith(prefix)).collect(ImmutableSet.toImmutableSet());
    }

    public static Optional<Callbacks.BeforeAgentCallback> resolveBeforeAgentCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.BeforeAgentCallback.class);
    }

    public static Optional<Callbacks.AfterAgentCallback> resolveAfterAgentCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.AfterAgentCallback.class);
    }

    public static Optional<Callbacks.BeforeModelCallback> resolveBeforeModelCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.BeforeModelCallback.class);
    }

    public static Optional<Callbacks.AfterModelCallback> resolveAfterModelCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.AfterModelCallback.class);
    }

    public static Optional<Callbacks.BeforeToolCallback> resolveBeforeToolCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.BeforeToolCallback.class);
    }

    public static Optional<Callbacks.AfterToolCallback> resolveAfterToolCallback(String name) {
        return ComponentRegistry.getInstance().get(name, Callbacks.AfterToolCallback.class);
    }

    private static <T> Optional<Class<? extends T>> getType(String name, Class<T> type) {
        return ComponentRegistry.getInstance().get(name, Class.class).filter(type::isAssignableFrom).map(clazz -> clazz.asSubclass(type));
    }

    private static Optional<Class<? extends BaseToolset>> loadToolsetClass(String className) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (BaseToolset.class.isAssignableFrom(clazz)) {
                return Optional.of(clazz.asSubclass(BaseToolset.class));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

