/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.applicationintegrationtoolset;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.tools.applicationintegrationtoolset.ConnectionsClient;
import com.google.adk.tools.applicationintegrationtoolset.IntegrationClient;
import com.google.adk.tools.applicationintegrationtoolset.IntegrationConnectorTool;
import com.google.common.base.Strings;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class ApplicationIntegrationToolset
implements BaseToolset {
    String project;
    String location;
    @Nullable String integration;
    @Nullable List<String> triggers;
    @Nullable String connection;
    @Nullable Map<String, List<String>> entityOperations;
    @Nullable List<String> actions;
    String serviceAccountJson;
    @Nullable String toolNamePrefix;
    @Nullable String toolInstructions;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    IntegrationConnectorTool.HttpExecutor httpExecutor;

    public ApplicationIntegrationToolset(String project, String location, String integration, List<String> triggers, String connection, Map<String, List<String>> entityOperations, List<String> actions, String serviceAccountJson, String toolNamePrefix, String toolInstructions) {
        this(project, location, integration, triggers, connection, entityOperations, actions, serviceAccountJson, toolNamePrefix, toolInstructions, new IntegrationConnectorTool.DefaultHttpExecutor().createExecutor(serviceAccountJson));
    }

    ApplicationIntegrationToolset(String project, String location, String integration, List<String> triggers, String connection, Map<String, List<String>> entityOperations, List<String> actions, String serviceAccountJson, String toolNamePrefix, String toolInstructions, IntegrationConnectorTool.HttpExecutor httpExecutor) {
        this.project = project;
        this.location = location;
        this.integration = integration;
        this.triggers = triggers;
        this.connection = connection;
        this.entityOperations = entityOperations;
        this.actions = actions;
        this.serviceAccountJson = serviceAccountJson;
        this.toolNamePrefix = toolNamePrefix;
        this.toolInstructions = toolInstructions;
        this.httpExecutor = httpExecutor;
    }

    List<String> getPathUrl(String openApiSchemaString) throws Exception {
        ArrayList<String> pathUrls = new ArrayList<String>();
        JsonNode topLevelNode = OBJECT_MAPPER.readTree(openApiSchemaString);
        JsonNode specNode = topLevelNode.path("openApiSpec");
        if (specNode.isMissingNode() || !specNode.isTextual()) {
            throw new IllegalArgumentException("Failed to get OpenApiSpec, please check the project and region for the integration.");
        }
        JsonNode rootNode = OBJECT_MAPPER.readTree(specNode.asText());
        JsonNode pathsNode = rootNode.path("paths");
        Iterator paths = pathsNode.fields();
        while (paths.hasNext()) {
            Map.Entry pathEntry = (Map.Entry)paths.next();
            String pathUrl = (String)pathEntry.getKey();
            pathUrls.add(pathUrl);
        }
        return pathUrls;
    }

    private List<BaseTool> getAllTools() throws Exception {
        String openApiSchemaString = null;
        ArrayList<BaseTool> tools = new ArrayList<BaseTool>();
        if (!Strings.isNullOrEmpty((String)this.integration)) {
            IntegrationClient integrationClient = new IntegrationClient(this.project, this.location, this.integration, this.triggers, null, null, null, this.httpExecutor);
            openApiSchemaString = integrationClient.generateOpenApiSpec();
            List<String> pathUrls = this.getPathUrl(openApiSchemaString);
            for (String pathUrl : pathUrls) {
                String toolName = integrationClient.getOperationIdFromPathUrl(openApiSchemaString, pathUrl);
                if (toolName == null) continue;
                tools.add(new IntegrationConnectorTool(openApiSchemaString, pathUrl, toolName, this.toolInstructions, null, null, null, this.serviceAccountJson, this.httpExecutor));
            }
        } else if (!(Strings.isNullOrEmpty((String)this.connection) || this.entityOperations == null && this.actions == null)) {
            IntegrationClient integrationClient = new IntegrationClient(this.project, this.location, null, null, this.connection, this.entityOperations, this.actions, this.httpExecutor);
            ObjectNode parentOpenApiSpec = OBJECT_MAPPER.createObjectNode();
            ObjectNode openApiSpec = integrationClient.getOpenApiSpecForConnection(this.toolNamePrefix, this.toolInstructions);
            String openApiSpecString = OBJECT_MAPPER.writeValueAsString((Object)openApiSpec);
            parentOpenApiSpec.put("openApiSpec", openApiSpecString);
            openApiSchemaString = OBJECT_MAPPER.writeValueAsString((Object)parentOpenApiSpec);
            List<String> pathUrls = this.getPathUrl(openApiSchemaString);
            for (String pathUrl : pathUrls) {
                String toolName = integrationClient.getOperationIdFromPathUrl(openApiSchemaString, pathUrl);
                if (Strings.isNullOrEmpty((String)toolName)) continue;
                ConnectionsClient connectionsClient = new ConnectionsClient(this.project, this.location, this.connection, this.httpExecutor, OBJECT_MAPPER);
                ConnectionsClient.ConnectionDetails connectionDetails = connectionsClient.getConnectionDetails();
                tools.add(new IntegrationConnectorTool(openApiSchemaString, pathUrl, toolName, "", connectionDetails.name, connectionDetails.serviceName, connectionDetails.host, this.serviceAccountJson, this.httpExecutor));
            }
        } else {
            throw new IllegalArgumentException("Invalid request, Either integration or (connection and (entityOperations or actions)) should be provided.");
        }
        return tools;
    }

    @Override
    public Flowable<BaseTool> getTools(@Nullable ReadonlyContext readonlyContext) {
        try {
            List<BaseTool> allTools = this.getAllTools();
            return Flowable.fromIterable(allTools);
        }
        catch (Exception e) {
            return Flowable.error((Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

