/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.UrlContext;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;

public final class UrlContextTool
extends BaseTool {
    public static final UrlContextTool INSTANCE = new UrlContextTool();

    public UrlContextTool() {
        super("url_context", "url_context");
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        GenerateContentConfig.Builder configBuilder = llmRequestBuilder.build().config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder());
        List existingTools = (List)configBuilder.build().tools().orElse(ImmutableList.of());
        ImmutableList.Builder updatedToolsBuilder = ImmutableList.builder();
        updatedToolsBuilder.addAll((Iterable)existingTools);
        String model = llmRequestBuilder.build().model().get();
        if (model == null || !model.startsWith("gemini-2")) {
            return Completable.error((Throwable)new IllegalArgumentException("Url context tool is not supported for model " + model));
        }
        updatedToolsBuilder.add((Object)Tool.builder().urlContext(UrlContext.builder().build()).build());
        configBuilder.tools((List)updatedToolsBuilder.build());
        llmRequestBuilder.config(configBuilder.build());
        return Completable.complete();
    }
}

