/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.EventActions;
import com.google.adk.memory.SearchMemoryResponse;
import com.google.adk.tools.ToolConfirmation;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Single;
import java.util.Optional;
import javax.annotation.Nullable;

public class ToolContext
extends CallbackContext {
    private Optional<String> functionCallId = Optional.empty();
    private Optional<ToolConfirmation> toolConfirmation = Optional.empty();

    private ToolContext(InvocationContext invocationContext, EventActions eventActions, Optional<String> functionCallId, Optional<ToolConfirmation> toolConfirmation) {
        super(invocationContext, eventActions);
        this.functionCallId = functionCallId;
        this.toolConfirmation = toolConfirmation;
    }

    public EventActions actions() {
        return this.eventActions;
    }

    public void setActions(EventActions actions) {
        this.eventActions = actions;
    }

    public Optional<String> functionCallId() {
        return this.functionCallId;
    }

    public void functionCallId(String functionCallId) {
        this.functionCallId = Optional.ofNullable(functionCallId);
    }

    public Optional<ToolConfirmation> toolConfirmation() {
        return this.toolConfirmation;
    }

    public void toolConfirmation(ToolConfirmation toolConfirmation) {
        this.toolConfirmation = Optional.ofNullable(toolConfirmation);
    }

    private void requestCredential() {
        throw new UnsupportedOperationException("Credential request not implemented yet.");
    }

    private void getAuthResponse() {
        throw new UnsupportedOperationException("Auth response retrieval not implemented yet.");
    }

    public void requestConfirmation(@Nullable String hint, @Nullable Object payload) {
        if (this.functionCallId.isEmpty()) {
            throw new IllegalStateException("function_call_id is not set.");
        }
        this.eventActions.requestedToolConfirmations().put(this.functionCallId.get(), ToolConfirmation.builder().hint(hint).payload(payload).build());
    }

    public void requestConfirmation(@Nullable String hint) {
        this.requestConfirmation(hint, null);
    }

    public void requestConfirmation() {
        this.requestConfirmation(null, null);
    }

    public Single<SearchMemoryResponse> searchMemory(String query) {
        if (this.invocationContext.memoryService() == null) {
            throw new IllegalStateException("Memory service is not initialized.");
        }
        return this.invocationContext.memoryService().searchMemory(this.invocationContext.session().appName(), this.invocationContext.session().userId(), query);
    }

    public static Builder builder(InvocationContext invocationContext) {
        return new Builder(invocationContext);
    }

    public Builder toBuilder() {
        return new Builder(this.invocationContext).actions(this.eventActions).functionCallId(this.functionCallId.orElse(null)).toolConfirmation(this.toolConfirmation.orElse(null));
    }

    public static final class Builder {
        private final InvocationContext invocationContext;
        private EventActions eventActions = EventActions.builder().build();
        private Optional<String> functionCallId = Optional.empty();
        private Optional<ToolConfirmation> toolConfirmation = Optional.empty();

        private Builder(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
        }

        @CanIgnoreReturnValue
        public Builder actions(EventActions actions) {
            this.eventActions = actions;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder functionCallId(String functionCallId) {
            this.functionCallId = Optional.ofNullable(functionCallId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder toolConfirmation(ToolConfirmation toolConfirmation) {
            this.toolConfirmation = Optional.ofNullable(toolConfirmation);
            return this;
        }

        public ToolContext build() {
            return new ToolContext(this.invocationContext, this.eventActions, this.functionCallId, this.toolConfirmation);
        }
    }
}

