/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.utils.ComponentRegistry;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class LongRunningFunctionTool
extends FunctionTool {
    public static LongRunningFunctionTool create(Method func) {
        return LongRunningFunctionTool.create(func, false);
    }

    public static LongRunningFunctionTool create(Method func, boolean requireConfirmation) {
        return new LongRunningFunctionTool(func, requireConfirmation);
    }

    public static LongRunningFunctionTool create(Class<?> cls, String methodName) {
        return LongRunningFunctionTool.create(cls, methodName, false);
    }

    public static LongRunningFunctionTool create(Class<?> cls, String methodName, boolean requireConfirmation) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return LongRunningFunctionTool.create(method, requireConfirmation);
        }
        throw new IllegalArgumentException(String.format("Method %s not found in class %s.", methodName, cls.getName()));
    }

    public static LongRunningFunctionTool create(Object instance, String methodName) {
        return LongRunningFunctionTool.create(instance, methodName, false);
    }

    public static LongRunningFunctionTool create(Object instance, String methodName, boolean requireConfirmation) {
        Class<?> cls = instance.getClass();
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return LongRunningFunctionTool.create(instance, method, requireConfirmation);
        }
        throw new IllegalArgumentException(String.format("Method %s not found in class %s.", methodName, cls.getName()));
    }

    public static LongRunningFunctionTool create(@Nullable Object instance, Method method) {
        return LongRunningFunctionTool.create(instance, method, false);
    }

    public static LongRunningFunctionTool create(@Nullable Object instance, Method method, boolean requireConfirmation) {
        return new LongRunningFunctionTool(instance, method, requireConfirmation);
    }

    public static LongRunningFunctionTool create(FunctionTool tool) {
        return LongRunningFunctionTool.create(tool.instance(), tool.func(), tool.requireConfirmation());
    }

    private LongRunningFunctionTool(Method func, boolean requireConfirmation) {
        super(null, func, true, requireConfirmation);
    }

    private LongRunningFunctionTool(@Nullable Object instance, Method func, boolean requireConfirmation) {
        super(instance, func, true, requireConfirmation);
    }

    public static LongRunningFunctionTool fromConfig(BaseTool.ToolArgsConfig config, String configAbsPath) {
        String funcName = config.getOrEmpty("func", new TypeReference<String>(){}).orElseThrow(() -> new IllegalArgumentException("\"func\" argument should be name of a function"));
        FunctionTool funcTool = ComponentRegistry.getInstance().get(funcName, FunctionTool.class).orElseThrow(() -> new IllegalArgumentException(String.format("failed to find FunctionTool \"%s\" in the ComponentRegistry", funcName)));
        return LongRunningFunctionTool.create(funcTool);
    }
}

