/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.InvocationContext;
import com.google.adk.tools.Annotations;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionCallingUtils;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTool
extends BaseTool {
    private static final Logger logger = LoggerFactory.getLogger(FunctionTool.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonBaseModel.getMapper();
    @Nullable
    private final Object instance;
    private final Method func;
    private final FunctionDeclaration funcDeclaration;
    private final boolean requireConfirmation;

    public static FunctionTool create(Object instance, Method func) {
        return FunctionTool.create(instance, func, false);
    }

    public static FunctionTool create(Object instance, Method func, boolean requireConfirmation) {
        if (!FunctionTool.areParametersAnnotatedWithSchema(func) && FunctionTool.wasCompiledWithDefaultParameterNames(func)) {
            logger.error("Functions used in tools must have their parameters annotated with @Schema or at least\n the code must be compiled with the -parameters flag as a fallback. Your function\n tool will likely not work as expected and exit at runtime.\n");
        }
        if (!Modifier.isStatic(func.getModifiers()) && !func.getDeclaringClass().isInstance(instance)) {
            throw new IllegalArgumentException(String.format("The instance provided is not an instance of the declaring class of the method. Expected: %s, Actual: %s", func.getDeclaringClass().getName(), instance.getClass().getName()));
        }
        return new FunctionTool(instance, func, false, requireConfirmation);
    }

    public static FunctionTool create(Method func) {
        return FunctionTool.create(func, false);
    }

    public static FunctionTool create(Method func, boolean requireConfirmation) {
        if (!FunctionTool.areParametersAnnotatedWithSchema(func) && FunctionTool.wasCompiledWithDefaultParameterNames(func)) {
            logger.error("Functions used in tools must have their parameters annotated with @Schema or at least\n the code must be compiled with the -parameters flag as a fallback. Your function\n tool will likely not work as expected and exit at runtime.\n");
        }
        if (!Modifier.isStatic(func.getModifiers())) {
            throw new IllegalArgumentException("The method provided must be static.");
        }
        return new FunctionTool(null, func, false, requireConfirmation);
    }

    public static FunctionTool create(Class<?> cls, String methodName) {
        return FunctionTool.create(cls, methodName, false);
    }

    public static FunctionTool create(Class<?> cls, String methodName, boolean requireConfirmation) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName) || !Modifier.isStatic(method.getModifiers())) continue;
            return FunctionTool.create(null, method, requireConfirmation);
        }
        throw new IllegalArgumentException(String.format("Static method %s not found in class %s.", methodName, cls.getName()));
    }

    public static FunctionTool create(Object instance, String methodName) {
        return FunctionTool.create(instance, methodName, false);
    }

    public static FunctionTool create(Object instance, String methodName, boolean requireConfirmation) {
        Class<?> cls = instance.getClass();
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName) || Modifier.isStatic(method.getModifiers())) continue;
            return FunctionTool.create(instance, method, requireConfirmation);
        }
        throw new IllegalArgumentException(String.format("Instance method %s not found in class %s.", methodName, cls.getName()));
    }

    private static boolean areParametersAnnotatedWithSchema(Method func) {
        for (Parameter parameter : func.getParameters()) {
            if (parameter.isAnnotationPresent(Annotations.Schema.class) && !parameter.getAnnotation(Annotations.Schema.class).name().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean wasCompiledWithDefaultParameterNames(Method func) {
        for (Parameter parameter : func.getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName.matches("arg\\d+")) continue;
            return false;
        }
        return true;
    }

    protected FunctionTool(@Nullable Object instance, Method func, boolean isLongRunning) {
        this(instance, func, isLongRunning, false);
    }

    protected FunctionTool(@Nullable Object instance, Method func, boolean isLongRunning, boolean requireConfirmation) {
        super(func.isAnnotationPresent(Annotations.Schema.class) && !func.getAnnotation(Annotations.Schema.class).name().isEmpty() ? func.getAnnotation(Annotations.Schema.class).name() : func.getName(), func.isAnnotationPresent(Annotations.Schema.class) ? func.getAnnotation(Annotations.Schema.class).description() : "", isLongRunning);
        boolean isStatic = Modifier.isStatic(func.getModifiers());
        if (isStatic && instance != null) {
            throw new IllegalArgumentException("Static function tool must not have an instance.");
        }
        if (!isStatic && instance == null) {
            throw new IllegalArgumentException("Instance function tool must have an instance.");
        }
        this.instance = instance;
        this.func = func;
        this.funcDeclaration = FunctionCallingUtils.buildFunctionDeclaration(this.func, (List<String>)ImmutableList.of((Object)"toolContext", (Object)"inputStream"));
        this.requireConfirmation = requireConfirmation;
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        return Optional.of(this.funcDeclaration);
    }

    public Method func() {
        return this.func;
    }

    @Nullable
    Object instance() {
        return this.instance;
    }

    boolean requireConfirmation() {
        return this.requireConfirmation;
    }

    public boolean isStreaming() {
        ParameterizedType parameterizedType;
        Type type;
        Type returnType = this.func.getGenericReturnType();
        if (returnType instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)returnType).getRawType()) instanceof Class) {
            Class rawType = (Class)type;
            return Flowable.class.isAssignableFrom(rawType);
        }
        return false;
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        try {
            if (this.requireConfirmation) {
                if (toolContext.toolConfirmation().isEmpty()) {
                    toolContext.requestConfirmation(String.format("Please approve or reject the tool call %s() by responding with a FunctionResponse with an expected ToolConfirmation payload.", this.name()));
                    return Single.just((Object)ImmutableMap.of((Object)"error", (Object)"This tool call requires confirmation, please approve or reject."));
                }
                if (!toolContext.toolConfirmation().get().confirmed()) {
                    return Single.just((Object)ImmutableMap.of((Object)"error", (Object)"This tool call is rejected."));
                }
            }
            return this.call(args, toolContext).defaultIfEmpty((Object)ImmutableMap.of());
        }
        catch (Exception e) {
            logger.error("Exception occurred while calling function tool: " + this.func.getName(), (Throwable)e);
            return Single.just((Object)ImmutableMap.of((Object)"status", (Object)"error", (Object)"message", (Object)"An internal error occurred."));
        }
    }

    private Maybe<Map<String, Object>> call(Map<String, Object> args, ToolContext toolContext) throws IllegalAccessException, InvocationTargetException {
        Object[] arguments = this.buildArguments(args, toolContext, null);
        Object result = this.func.invoke(this.instance, arguments);
        if (result == null) {
            return Maybe.empty();
        }
        if (result instanceof Maybe) {
            return ((Maybe)result).map(data -> (Map)OBJECT_MAPPER.convertValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        if (result instanceof Single) {
            return ((Single)result).map(data -> (Map)OBJECT_MAPPER.convertValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){})).toMaybe();
        }
        try {
            return Maybe.just((Object)((Map)OBJECT_MAPPER.convertValue(result, (TypeReference)new TypeReference<Map<String, Object>>(){})));
        }
        catch (IllegalArgumentException e) {
            return Maybe.just((Object)ImmutableMap.of((Object)"result", (Object)result));
        }
    }

    public Flowable<Map<String, Object>> callLive(Map<String, Object> args, ToolContext toolContext, InvocationContext invocationContext) throws IllegalAccessException, InvocationTargetException {
        Object[] arguments = this.buildArguments(args, toolContext, invocationContext);
        Object result = this.func.invoke(this.instance, arguments);
        if (result instanceof Flowable) {
            return (Flowable)result;
        }
        throw new IllegalArgumentException("callLive was called but the underlying function does not return a Flowable.");
    }

    private Object[] buildArguments(Map<String, Object> args, ToolContext toolContext, @Nullable InvocationContext invocationContext) {
        Parameter[] parameters = this.func.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String paramName;
            String string = paramName = parameters[i].isAnnotationPresent(Annotations.Schema.class) && !parameters[i].getAnnotation(Annotations.Schema.class).name().isEmpty() ? parameters[i].getAnnotation(Annotations.Schema.class).name() : parameters[i].getName();
            if ("toolContext".equals(paramName)) {
                arguments[i] = toolContext;
                continue;
            }
            if ("inputStream".equals(paramName)) {
                if (invocationContext != null && invocationContext.activeStreamingTools().containsKey(this.name()) && invocationContext.activeStreamingTools().get(this.name()).stream() != null) {
                    arguments[i] = invocationContext.activeStreamingTools().get(this.name()).stream();
                    continue;
                }
                arguments[i] = null;
                continue;
            }
            Annotations.Schema schema = parameters[i].getAnnotation(Annotations.Schema.class);
            if (!args.containsKey(paramName)) {
                if (schema != null && schema.optional()) {
                    arguments[i] = null;
                    continue;
                }
                throw new IllegalArgumentException(String.format("The parameter '%s' was not found in the arguments provided by the model.", paramName));
            }
            Class<?> paramType = parameters[i].getType();
            Object argValue = args.get(paramName);
            if (paramType.equals(List.class)) {
                if (argValue instanceof List) {
                    Type type = ((ParameterizedType)parameters[i].getParameterizedType()).getActualTypeArguments()[0];
                    Class<?> typeArgClass = FunctionTool.getTypeClass(type, paramName);
                    arguments[i] = FunctionTool.createList((List)argValue, typeArgClass);
                    continue;
                }
            } else if (argValue instanceof Map) {
                arguments[i] = OBJECT_MAPPER.convertValue(argValue, paramType);
                continue;
            }
            arguments[i] = FunctionTool.castValue(argValue, paramType);
        }
        return arguments;
    }

    private static Class<?> getTypeClass(Type type, String paramName) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        throw new IllegalArgumentException(String.format("Unsupported parameterized type %s for '%s'", type, paramName));
    }

    private static List<Object> createList(List<Object> values, Class<?> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (type == null) {
            return list;
        }
        Class<?> cls = type;
        for (Object value : values) {
            if (cls == Integer.class || cls == Long.class || cls == Double.class || cls == Float.class || cls == Boolean.class || cls == String.class) {
                list.add(FunctionTool.castValue(value, cls));
                continue;
            }
            list.add(OBJECT_MAPPER.convertValue(value, type));
        }
        return list;
    }

    private static Object castValue(Object value, Class<?> type) {
        if ((type.equals(Integer.class) || type.equals(Integer.TYPE)) && value instanceof Integer) {
            return value;
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            if (value instanceof Long || value instanceof Integer) {
                return value;
            }
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            if (value instanceof Double) {
                Double d = (Double)value;
                return (double)d;
            }
            if (value instanceof Float) {
                Float f = (Float)value;
                return f.doubleValue();
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return i.doubleValue();
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                return l.doubleValue();
            }
        } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            if (value instanceof Double) {
                Double d = (Double)value;
                return Float.valueOf(d.floatValue());
            }
            if (value instanceof Float) {
                Float f = (Float)value;
                return Float.valueOf(f.floatValue());
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return Float.valueOf(i.floatValue());
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                return Float.valueOf(l.floatValue());
            }
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE) ? value instanceof Boolean : type.equals(String.class) && value instanceof String) {
            return value;
        }
        return OBJECT_MAPPER.convertValue(value, type);
    }
}

