/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.Annotations;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionCallingUtils {
    private static final Logger logger = LoggerFactory.getLogger(FunctionCallingUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonBaseModel.getMapper();

    public static FunctionDeclaration buildFunctionDeclaration(Method func, List<String> ignoreParams) {
        String name = func.isAnnotationPresent(Annotations.Schema.class) && !func.getAnnotation(Annotations.Schema.class).name().isEmpty() ? func.getAnnotation(Annotations.Schema.class).name() : func.getName();
        FunctionDeclaration.Builder builder = FunctionDeclaration.builder().name(name);
        if (func.isAnnotationPresent(Annotations.Schema.class) && !func.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            builder.description(func.getAnnotation(Annotations.Schema.class).description());
        }
        ArrayList<String> required = new ArrayList<String>();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        for (Parameter param : func.getParameters()) {
            String paramName;
            String string = paramName = param.isAnnotationPresent(Annotations.Schema.class) && !param.getAnnotation(Annotations.Schema.class).name().isEmpty() ? param.getAnnotation(Annotations.Schema.class).name() : param.getName();
            if (ignoreParams.contains(paramName)) continue;
            Annotations.Schema schema = param.getAnnotation(Annotations.Schema.class);
            if (schema == null || !schema.optional()) {
                required.add(paramName);
            }
            properties.put(paramName, FunctionCallingUtils.buildSchemaFromParameter(param));
        }
        builder.parameters(Schema.builder().required(required).properties(properties).type("OBJECT").build());
        Type returnType = func.getGenericReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            builder.response(Schema.builder().type("NULL").build());
        } else {
            ParameterizedType parameterizedReturnType;
            String rawTypeName;
            Type actualReturnType = returnType;
            if (returnType instanceof ParameterizedType && ((rawTypeName = ((Class)(parameterizedReturnType = (ParameterizedType)returnType).getRawType()).getName()).equals("io.reactivex.rxjava3.core.Maybe") || rawTypeName.equals("io.reactivex.rxjava3.core.Single") || rawTypeName.equals("io.reactivex.rxjava3.core.Flowable"))) {
                actualReturnType = parameterizedReturnType.getActualTypeArguments()[0];
            }
            builder.response(FunctionCallingUtils.buildSchemaFromType(actualReturnType));
        }
        return builder.build();
    }

    static FunctionDeclaration buildFunctionDeclaration(JsonBaseModel func, String description) {
        String jsonString = func.toJson();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jsonString) ? 1 : 0) != 0, (Object)"Input String can't be null or empty.");
        FunctionDeclaration declaration = FunctionDeclaration.fromJson((String)jsonString);
        declaration = declaration.toBuilder().description(description).build();
        if (declaration.name().isEmpty() || ((String)declaration.name().get()).isEmpty()) {
            throw new IllegalArgumentException("name field must be present.");
        }
        return declaration;
    }

    private static Schema buildSchemaFromParameter(Parameter param) {
        Schema schema = FunctionCallingUtils.buildSchemaFromType(param.getParameterizedType());
        if (param.isAnnotationPresent(Annotations.Schema.class) && !param.getAnnotation(Annotations.Schema.class).description().isEmpty()) {
            return schema.toBuilder().description(param.getAnnotation(Annotations.Schema.class).description()).build();
        }
        return schema;
    }

    public static Schema buildSchemaFromType(Type type) {
        return FunctionCallingUtils.buildSchemaRecursive(OBJECT_MAPPER.constructType(type), new SchemaGenerationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema buildSchemaRecursive(JavaType javaType, SchemaGenerationContext context) {
        Schema resultSchema;
        if (context.isProcessing(javaType)) {
            logger.warn("Type {} is recursive. Omitting from schema.", (Object)javaType.toCanonical());
            return Schema.builder().type("OBJECT").description("Recursive reference to " + javaType.toCanonical() + " omitted.").build();
        }
        Optional<Schema> cachedSchema = context.getDefinition(javaType);
        if (cachedSchema.isPresent()) {
            return cachedSchema.get();
        }
        context.startProcessing(javaType);
        try {
            Schema.Builder builder = Schema.builder();
            Class rawClass = javaType.getRawClass();
            if (javaType.isCollectionLikeType() && List.class.isAssignableFrom(rawClass)) {
                builder.type("ARRAY").items(FunctionCallingUtils.buildSchemaRecursive(javaType.getContentType(), context));
            } else if (javaType.isMapLikeType()) {
                builder.type("OBJECT");
            } else if (String.class.equals((Object)rawClass)) {
                builder.type("STRING");
            } else if (Boolean.class.equals((Object)rawClass) || Boolean.TYPE.equals(rawClass)) {
                builder.type("BOOLEAN");
            } else if (Integer.class.equals((Object)rawClass) || Integer.TYPE.equals(rawClass)) {
                builder.type("INTEGER");
            } else if (Double.class.equals((Object)rawClass) || Double.TYPE.equals(rawClass) || Float.class.equals((Object)rawClass) || Float.TYPE.equals(rawClass) || Long.class.equals((Object)rawClass) || Long.TYPE.equals(rawClass)) {
                builder.type("NUMBER");
            } else if (rawClass.isEnum()) {
                ArrayList<String> enumValues = new ArrayList<String>();
                for (Object enumConstant : rawClass.getEnumConstants()) {
                    enumValues.add(enumConstant.toString());
                }
                builder.enum_(enumValues).type("STRING").format("enum");
            } else {
                if (!OBJECT_MAPPER.canSerialize(rawClass)) {
                    throw new IllegalArgumentException("Unsupported type: " + rawClass.getName() + ". The type must be a Jackson-serializable POJO or a registered primitive. Opaque types like Protobuf models are not supported directly.");
                }
                BeanDescription beanDescription = OBJECT_MAPPER.getSerializationConfig().introspect(javaType);
                LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                ArrayList<String> required = new ArrayList<String>();
                for (BeanPropertyDefinition property : beanDescription.findProperties()) {
                    AnnotatedMember member = property.getPrimaryMember();
                    if (member == null) continue;
                    properties.put(property.getName(), FunctionCallingUtils.buildSchemaRecursive(member.getType(), context));
                    if (!property.isRequired()) continue;
                    required.add(property.getName());
                }
                builder.type("OBJECT").properties(properties);
                if (!required.isEmpty()) {
                    builder.required(required);
                }
            }
            resultSchema = builder.build();
        }
        finally {
            context.finishProcessing(javaType);
        }
        context.addDefinition(javaType, resultSchema);
        return resultSchema;
    }

    private FunctionCallingUtils() {
    }

    private static class SchemaGenerationContext {
        private final Map<JavaType, Schema> definitions = new LinkedHashMap<JavaType, Schema>();
        private final Set<JavaType> processingStack = new HashSet<JavaType>();

        private SchemaGenerationContext() {
        }

        boolean isProcessing(JavaType type) {
            return this.processingStack.contains(type);
        }

        void startProcessing(JavaType type) {
            this.processingStack.add(type);
        }

        void finishProcessing(JavaType type) {
            this.processingStack.remove(type);
        }

        Optional<Schema> getDefinition(JavaType type) {
            return Optional.ofNullable(this.definitions.get(type));
        }

        void addDefinition(JavaType type, Schema schema) {
            this.definitions.put(type, schema);
        }
    }
}

