/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.LiveConnectConfig;
import com.google.genai.types.Tool;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTool {
    private final String name;
    private final String description;
    private final boolean isLongRunning;
    private final HashMap<String, Object> customMetadata;

    protected BaseTool(@Nonnull String name, @Nonnull String description) {
        this(name, description, false);
    }

    protected BaseTool(@Nonnull String name, @Nonnull String description, boolean isLongRunning) {
        this.name = name;
        this.description = description;
        this.isLongRunning = isLongRunning;
        this.customMetadata = new HashMap();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean longRunning() {
        return this.isLongRunning;
    }

    public Optional<FunctionDeclaration> declaration() {
        return Optional.empty();
    }

    public ImmutableMap<String, Object> customMetadata() {
        return ImmutableMap.copyOf(this.customMetadata);
    }

    public void setCustomMetadata(String key, Object value) {
        this.customMetadata.put(key, value);
    }

    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    @CanIgnoreReturnValue
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        if (this.declaration().isEmpty()) {
            return Completable.complete();
        }
        llmRequestBuilder.appendTools((List<BaseTool>)ImmutableList.of((Object)this));
        LlmRequest llmRequest = llmRequestBuilder.build();
        ImmutableList<Tool> toolsWithoutFunctionDeclarations = BaseTool.findToolsWithoutFunctionDeclarations(llmRequest);
        Tool toolWithFunctionDeclarations = BaseTool.findToolWithFunctionDeclarations(llmRequest);
        toolWithFunctionDeclarations = toolWithFunctionDeclarations == null ? Tool.builder().functionDeclarations((List)ImmutableList.of((Object)this.declaration().get())).build() : toolWithFunctionDeclarations.toBuilder().functionDeclarations((List)ImmutableList.builder().addAll((Iterable)toolWithFunctionDeclarations.functionDeclarations().orElse(ImmutableList.of())).add((Object)this.declaration().get()).build()).build();
        ImmutableList newTools = new ImmutableList.Builder().addAll(toolsWithoutFunctionDeclarations).add((Object)toolWithFunctionDeclarations).build();
        GenerateContentConfig generateContentConfig = llmRequest.config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder()).tools((List)newTools).build();
        LiveConnectConfig liveConnectConfig = llmRequest.liveConnectConfig().toBuilder().tools((List)newTools).build();
        llmRequestBuilder.config(generateContentConfig);
        llmRequestBuilder.liveConnectConfig(liveConnectConfig);
        return Completable.complete();
    }

    private static @Nullable Tool findToolWithFunctionDeclarations(LlmRequest llmRequest) {
        return llmRequest.config().flatMap(config -> config.tools()).flatMap(tools -> tools.stream().filter(t -> t.functionDeclarations().isPresent()).findFirst()).orElse(null);
    }

    private static ImmutableList<Tool> findToolsWithoutFunctionDeclarations(LlmRequest llmRequest) {
        return llmRequest.config().flatMap(config -> config.tools()).map(tools -> (ImmutableList)tools.stream().filter(t -> t.functionDeclarations().isEmpty()).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    @DoNotCall(value="Always throws com.google.adk.agents.ConfigAgentUtils.ConfigurationException")
    public static BaseTool fromConfig(ToolConfig config, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        throw new ConfigAgentUtils.ConfigurationException("fromConfig not implemented for " + BaseTool.class.getSimpleName());
    }

    public static class ToolConfig
    extends JsonBaseModel {
        private String name;
        private ToolArgsConfig args;

        public ToolConfig() {
        }

        public ToolConfig(String name, ToolArgsConfig args) {
            this.name = name;
            this.args = args;
        }

        public String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ToolArgsConfig args() {
            return this.args;
        }

        public void setArgs(ToolArgsConfig args) {
            this.args = args;
        }
    }

    public static class ToolArgsConfig
    extends JsonBaseModel {
        private static final Logger log = LoggerFactory.getLogger(ToolArgsConfig.class);
        @JsonIgnore
        private final Map<String, Object> additionalProperties = new HashMap<String, Object>();

        public boolean isEmpty() {
            return this.additionalProperties.isEmpty();
        }

        public int size() {
            return this.additionalProperties.size();
        }

        @CanIgnoreReturnValue
        public ToolArgsConfig put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public <T> Optional<T> getOrEmpty(String key, TypeReference<T> typeReference) {
            if (!this.additionalProperties.containsKey(key)) {
                return Optional.empty();
            }
            try {
                return Optional.of(JsonBaseModel.getMapper().convertValue(this.additionalProperties.get(key), typeReference));
            }
            catch (IllegalArgumentException e) {
                log.debug("Could not convert key {} into type: {}", (Object)key, (Object)e);
                return Optional.empty();
            }
        }

        public <T> T getOrDefault(String key, T defaultValue) {
            if (!this.additionalProperties.containsKey(key)) {
                return defaultValue;
            }
            return (T)JsonBaseModel.getMapper().convertValue(this.additionalProperties.get(key), new TypeReference<T>(){});
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        @JsonAnySetter
        public void setAdditionalProperty(String key, Object value) {
            this.additionalProperties.put(key, value);
        }
    }
}

