/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.ApigeeLlm;
import com.google.adk.models.BaseLlm;
import com.google.adk.models.Gemini;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LlmRegistry {
    private static final Map<String, BaseLlm> instances = new ConcurrentHashMap<String, BaseLlm>();
    private static final Map<String, LlmFactory> llmFactories = new ConcurrentHashMap<String, LlmFactory>();

    public static void registerLlm(String modelNamePattern, LlmFactory factory) {
        llmFactories.put(modelNamePattern, factory);
    }

    public static BaseLlm getLlm(String modelName) {
        return instances.computeIfAbsent(modelName, LlmRegistry::createLlm);
    }

    private static BaseLlm createLlm(String modelName) {
        for (Map.Entry<String, LlmFactory> entry : llmFactories.entrySet()) {
            if (!modelName.matches(entry.getKey())) continue;
            return entry.getValue().create(modelName);
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    static void registerTestLlm(String modelNamePattern, LlmFactory factory) {
        llmFactories.put(modelNamePattern, factory);
        instances.keySet().removeIf(modelName -> modelName.matches(modelNamePattern));
    }

    private LlmRegistry() {
    }

    static {
        LlmRegistry.registerLlm("gemini-.*", modelName -> Gemini.builder().modelName(modelName).build());
        LlmRegistry.registerLlm("apigee/.*", modelName -> ApigeeLlm.builder().modelName(modelName).build());
    }

    @FunctionalInterface
    public static interface LlmFactory {
        public BaseLlm create(String var1);
    }
}

