/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import com.google.genai.types.FileData;
import com.google.genai.types.Part;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class GeminiUtil {
    public static final String CONTINUE_OUTPUT_MESSAGE = "Continue output. DO NOT look at this line. ONLY look at the content before this line and system instruction.";

    private GeminiUtil() {
    }

    public static LlmRequest prepareGenenerateContentRequest(LlmRequest llmRequest, boolean sanitize) {
        return GeminiUtil.prepareGenenerateContentRequest(llmRequest, sanitize, true);
    }

    public static LlmRequest prepareGenenerateContentRequest(LlmRequest llmRequest, boolean sanitize, boolean stripThoughts) {
        if (sanitize) {
            llmRequest = GeminiUtil.sanitizeRequestForGeminiApi(llmRequest);
        }
        List<Content> contents = GeminiUtil.ensureModelResponse(llmRequest.contents());
        if (stripThoughts) {
            contents = GeminiUtil.stripThoughts(contents);
        }
        return llmRequest.toBuilder().contents(contents).build();
    }

    public static LlmRequest sanitizeRequestForGeminiApi(LlmRequest llmRequest) {
        LlmRequest.Builder requestBuilder = llmRequest.toBuilder();
        llmRequest.config().filter(config -> config.labels().isPresent()).ifPresent(config -> requestBuilder.config(config.toBuilder().labels((Map)ImmutableMap.of()).build()));
        if (llmRequest.contents().isEmpty()) {
            return requestBuilder.build();
        }
        ImmutableList updatedContents = (ImmutableList)llmRequest.contents().stream().map(content -> {
            if (content.parts().isEmpty() || ((List)content.parts().get()).isEmpty()) {
                return content;
            }
            ImmutableList updatedParts = (ImmutableList)((List)content.parts().get()).stream().map(part -> {
                Part.Builder partBuilder = part.toBuilder();
                if (part.inlineData().flatMap(Blob::displayName).isPresent()) {
                    Blob blob = (Blob)part.inlineData().get();
                    Blob.Builder newBlobBuilder = Blob.builder();
                    blob.data().ifPresent(arg_0 -> ((Blob.Builder)newBlobBuilder).data(arg_0));
                    blob.mimeType().ifPresent(arg_0 -> ((Blob.Builder)newBlobBuilder).mimeType(arg_0));
                    partBuilder.inlineData(newBlobBuilder.build());
                }
                if (part.fileData().flatMap(FileData::displayName).isPresent()) {
                    FileData fileData = (FileData)part.fileData().get();
                    FileData.Builder newFileDataBuilder = FileData.builder();
                    fileData.fileUri().ifPresent(arg_0 -> ((FileData.Builder)newFileDataBuilder).fileUri(arg_0));
                    fileData.mimeType().ifPresent(arg_0 -> ((FileData.Builder)newFileDataBuilder).mimeType(arg_0));
                    partBuilder.fileData(newFileDataBuilder.build());
                }
                return partBuilder.build();
            }).collect(ImmutableList.toImmutableList());
            return content.toBuilder().parts((List)updatedParts).build();
        }).collect(ImmutableList.toImmutableList());
        return requestBuilder.contents((List<Content>)updatedContents).build();
    }

    static List<Content> ensureModelResponse(List<Content> contents) {
        if (contents.isEmpty() || !Ascii.equalsIgnoreCase((CharSequence)((Content)Iterables.getLast(contents)).role().orElse(""), (CharSequence)"user")) {
            Content userContent = Content.builder().parts((List)ImmutableList.of((Object)Part.fromText((String)CONTINUE_OUTPUT_MESSAGE))).role("user").build();
            return (List)Stream.concat(contents.stream(), Stream.of(userContent)).collect(ImmutableList.toImmutableList());
        }
        return contents;
    }

    public static Optional<Part> getPart0FromLlmResponse(LlmResponse llmResponse) {
        return llmResponse.content().flatMap(Content::parts).filter(parts -> !parts.isEmpty()).map(parts -> (Part)parts.get(0));
    }

    public static String getTextFromLlmResponse(LlmResponse llmResponse) {
        return llmResponse.content().flatMap(Content::parts).filter(parts -> !parts.isEmpty()).map(parts -> (Part)parts.get(0)).flatMap(Part::text).orElse("");
    }

    public static boolean shouldEmitAccumulatedText(LlmResponse currentLlmResponse) {
        return currentLlmResponse.content().flatMap(Content::parts).filter(parts -> !parts.isEmpty()).map(parts -> (Part)parts.get(0)).flatMap(Part::inlineData).isEmpty();
    }

    public static List<Content> stripThoughts(List<Content> originalContents) {
        return (List)originalContents.stream().map(content -> {
            ImmutableList nonThoughtParts = (ImmutableList)((List)content.parts().orElse(ImmutableList.of())).stream().filter(part -> part.thought().map(isThought -> isThought == false).orElse(true)).collect(ImmutableList.toImmutableList());
            return content.toBuilder().parts((List)nonThoughtParts).build();
        }).collect(ImmutableList.toImmutableList());
    }
}

