/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.BaseLlm;
import com.google.adk.models.BaseLlmConnection;
import com.google.adk.models.Gemini;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.Client;
import com.google.genai.types.HttpOptions;
import io.reactivex.rxjava3.core.Flowable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ApigeeLlm
extends BaseLlm {
    private static final String GOOGLE_GENAI_USE_VERTEXAI_ENV_VARIABLE_NAME = "GOOGLE_GENAI_USE_VERTEXAI";
    private static final String APIGEE_PROXY_URL_ENV_VARIABLE_NAME = "APIGEE_PROXY_URL";
    private static final ImmutableMap<String, String> TRACKING_HEADERS;
    private final Gemini geminiDelegate;
    private final Client apiClient;
    private final HttpOptions httpOptions;

    private ApigeeLlm(String modelName, String proxyUrl, Map<String, String> customHeaders) {
        super(modelName);
        if (!ApigeeLlm.validateModelString(modelName)) {
            throw new IllegalArgumentException("Invalid model string, expected apigee/[<provider>/][<version>/]<model_id>: " + modelName);
        }
        String effectiveProxyUrl = proxyUrl;
        if (Strings.isNullOrEmpty((String)effectiveProxyUrl)) {
            effectiveProxyUrl = System.getenv(APIGEE_PROXY_URL_ENV_VARIABLE_NAME);
        }
        if (Strings.isNullOrEmpty((String)effectiveProxyUrl)) {
            throw new IllegalArgumentException("Apigee proxy URL is not set and not found in the environment variable APIGEE_PROXY_URL.");
        }
        HttpOptions.Builder httpOptionsBuilder = HttpOptions.builder().baseUrl(effectiveProxyUrl).headers(TRACKING_HEADERS);
        String apiVersion = ApigeeLlm.identifyApiVersion(modelName);
        if (!apiVersion.isEmpty()) {
            httpOptionsBuilder.apiVersion(apiVersion);
        }
        if (customHeaders != null) {
            httpOptionsBuilder.headers((Map)ImmutableMap.builder().putAll(TRACKING_HEADERS).putAll(customHeaders).buildOrThrow());
        }
        this.httpOptions = httpOptionsBuilder.build();
        Client.Builder apiClientBuilder = Client.builder().httpOptions(this.httpOptions);
        if (ApigeeLlm.isVertexAiModel(modelName)) {
            apiClientBuilder.vertexAI(true);
        }
        this.apiClient = apiClientBuilder.build();
        this.geminiDelegate = new Gemini(modelName, this.apiClient);
    }

    @VisibleForTesting
    ApigeeLlm(String modelName, Gemini geminiDelegate) {
        super(modelName);
        this.apiClient = null;
        this.httpOptions = null;
        this.geminiDelegate = geminiDelegate;
    }

    Client getApiClient() {
        return this.apiClient;
    }

    @VisibleForTesting
    HttpOptions getHttpOptions() {
        return this.httpOptions;
    }

    private static boolean isVertexAiModel(String model) {
        return !model.startsWith("apigee/gemini/") && (model.startsWith("apigee/vertex_ai/") || ApigeeLlm.isEnvEnabled(GOOGLE_GENAI_USE_VERTEXAI_ENV_VARIABLE_NAME));
    }

    private static String identifyApiVersion(String model) {
        String modelPart = model.substring("apigee/".length());
        String[] components = modelPart.split("/", -1);
        if (components.length == 3) {
            return components[1];
        }
        if (components.length == 2 && !components[0].equals("vertex_ai") && !components[0].equals("gemini") && components[0].startsWith("v")) {
            return components[0];
        }
        return "";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Flowable<LlmResponse> generateContent(LlmRequest llmRequest, boolean stream) {
        String modelToUse = llmRequest.model().orElse(this.model());
        String modelId = ApigeeLlm.getModelId(modelToUse);
        LlmRequest newLlmRequest = llmRequest.toBuilder().model(modelId).build();
        return this.geminiDelegate.generateContent(newLlmRequest, stream);
    }

    @Override
    public BaseLlmConnection connect(LlmRequest llmRequest) {
        String modelToUse = llmRequest.model().orElse(this.model());
        String modelId = ApigeeLlm.getModelId(modelToUse);
        LlmRequest newLlmRequest = llmRequest.toBuilder().model(modelId).build();
        return this.geminiDelegate.connect(newLlmRequest);
    }

    private static boolean validateModelString(String model) {
        if (!model.startsWith("apigee/")) {
            return false;
        }
        String modelPart = model.substring("apigee/".length());
        if (modelPart.isEmpty()) {
            return false;
        }
        String[] components = modelPart.split("/", -1);
        if (components[components.length - 1].isEmpty()) {
            return false;
        }
        if (components.length == 1) {
            return true;
        }
        if (components.length == 3) {
            if (!components[0].equals("vertex_ai") && !components[0].equals("gemini")) {
                return false;
            }
            return components[1].startsWith("v");
        }
        if (components.length == 2) {
            if (components[0].equals("vertex_ai") || components[0].equals("gemini")) {
                return true;
            }
            return components[0].startsWith("v");
        }
        return false;
    }

    private static boolean isEnvEnabled(String envVarName) {
        String value = System.getenv(envVarName);
        return Boolean.parseBoolean(value) || Objects.equals(value, "1");
    }

    private static String getModelId(String model) {
        if (!ApigeeLlm.validateModelString(model)) {
            throw new IllegalArgumentException("Invalid model string, expected apigee/[<provider>/][<version>/]<model_id>: " + model);
        }
        String modelPart = model.substring("apigee/".length());
        String[] components = modelPart.split("/", -1);
        return components[components.length - 1];
    }

    static {
        String frameworkLabel = "google-adk/0.5.0";
        String languageLabel = "gl-java/" + StandardSystemProperty.JAVA_VERSION.value();
        String versionHeaderValue = String.format("%s %s", "google-adk/0.5.0", languageLabel);
        TRACKING_HEADERS = ImmutableMap.of((Object)"x-goog-api-client", (Object)versionHeaderValue, (Object)"user-agent", (Object)versionHeaderValue);
    }

    public static class Builder {
        private String modelName;
        private String proxyUrl;
        private Map<String, String> customHeaders = new HashMap<String, String>();

        protected Builder() {
        }

        @CanIgnoreReturnValue
        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public ApigeeLlm build() {
            if (!ApigeeLlm.validateModelString(this.modelName)) {
                throw new IllegalArgumentException("Invalid model string: " + this.modelName);
            }
            return new ApigeeLlm(this.modelName, this.proxyUrl, this.customHeaders);
        }
    }
}

