/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.Telemetry;
import com.google.adk.agents.ActiveStreamingTool;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.RunConfig;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.tools.ToolConfirmation;
import com.google.adk.tools.ToolContext;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Functions {
    private static final String AF_FUNCTION_CALL_ID_PREFIX = "adk-";
    static final String REQUEST_CONFIRMATION_FUNCTION_CALL_NAME = "adk_request_confirmation";
    private static final Logger logger = LoggerFactory.getLogger(Functions.class);

    public static String generateClientFunctionCallId() {
        return AF_FUNCTION_CALL_ID_PREFIX + String.valueOf(UUID.randomUUID());
    }

    public static void populateClientFunctionCallId(Event modelResponseEvent) {
        Optional<Content> originalContentOptional = modelResponseEvent.content();
        if (originalContentOptional.isEmpty()) {
            return;
        }
        Content originalContent = originalContentOptional.get();
        List originalParts = (List)originalContent.parts().orElse(ImmutableList.of());
        if (originalParts.stream().noneMatch(part -> part.functionCall().isPresent())) {
            return;
        }
        ArrayList<Part> newParts = new ArrayList<Part>();
        boolean modified = false;
        for (Part part2 : originalParts) {
            if (part2.functionCall().isPresent()) {
                FunctionCall functionCall = (FunctionCall)part2.functionCall().get();
                if (functionCall.id().isEmpty() || ((String)functionCall.id().get()).isEmpty()) {
                    FunctionCall updatedFunctionCall = functionCall.toBuilder().id(Functions.generateClientFunctionCallId()).build();
                    newParts.add(part2.toBuilder().functionCall(updatedFunctionCall).build());
                    modified = true;
                    continue;
                }
                newParts.add(part2);
                continue;
            }
            newParts.add(part2);
        }
        if (modified) {
            String role = (String)originalContent.role().orElseThrow(() -> new IllegalStateException("Content role is missing in event: " + modelResponseEvent.id()));
            Content newContent = Content.builder().role(role).parts(newParts).build();
            modelResponseEvent.setContent(Optional.of(newContent));
        }
    }

    public static Maybe<Event> handleFunctionCalls(InvocationContext invocationContext, Event functionCallEvent, Map<String, BaseTool> tools) {
        return Functions.handleFunctionCalls(invocationContext, functionCallEvent, tools, (Map<String, ToolConfirmation>)ImmutableMap.of());
    }

    public static Maybe<Event> handleFunctionCalls(InvocationContext invocationContext, Event functionCallEvent, Map<String, BaseTool> tools, Map<String, ToolConfirmation> toolConfirmations) {
        ImmutableList<FunctionCall> functionCalls = functionCallEvent.functionCalls();
        for (FunctionCall functionCall2 : functionCalls) {
            if (tools.containsKey(functionCall2.name().get())) continue;
            throw new VerifyException("Tool not found: " + (String)functionCall2.name().get());
        }
        Function functionCallMapper = functionCall -> {
            BaseTool tool = (BaseTool)tools.get(functionCall.name().get());
            ToolContext toolContext = ToolContext.builder(invocationContext).functionCallId(functionCall.id().orElse("")).toolConfirmation((ToolConfirmation)toolConfirmations.get(functionCall.id().orElse(null))).build();
            Map functionArgs = (Map)functionCall.args().orElse(ImmutableMap.of());
            Maybe maybeFunctionResult = Functions.maybeInvokeBeforeToolCall(invocationContext, tool, functionArgs, toolContext).switchIfEmpty((MaybeSource)Maybe.defer(() -> Functions.callTool(tool, functionArgs, toolContext)));
            return maybeFunctionResult.map(Optional::of).defaultIfEmpty(Optional.empty()).onErrorResumeNext(t -> invocationContext.pluginManager().runOnToolErrorCallback(tool, functionArgs, toolContext, (Throwable)t).map(Optional::of).switchIfEmpty((SingleSource)Single.error((Throwable)t))).flatMapMaybe(optionalInitialResult -> {
                Map initialFunctionResult = optionalInitialResult.orElse(null);
                Maybe<Map<String, Object>> afterToolResultMaybe = Functions.maybeInvokeAfterToolCall(invocationContext, tool, functionArgs, toolContext, initialFunctionResult);
                return afterToolResultMaybe.map(Optional::of).defaultIfEmpty(Optional.ofNullable(initialFunctionResult)).flatMapMaybe(finalOptionalResult -> {
                    Map finalFunctionResult = finalOptionalResult.orElse(null);
                    if (tool.longRunning() && finalFunctionResult == null) {
                        return Maybe.empty();
                    }
                    Event functionResponseEvent = Functions.buildResponseEvent(tool, finalFunctionResult, toolContext, invocationContext);
                    return Maybe.just((Object)functionResponseEvent);
                });
            });
        };
        Flowable functionResponseEventsFlowable = invocationContext.runConfig().toolExecutionMode() == RunConfig.ToolExecutionMode.SEQUENTIAL ? Flowable.fromIterable(functionCalls).concatMapMaybe(functionCallMapper) : Flowable.fromIterable(functionCalls).flatMapMaybe(functionCallMapper);
        return functionResponseEventsFlowable.toList().flatMapMaybe(events -> {
            if (events.isEmpty()) {
                return Maybe.empty();
            }
            Optional<Event> maybeMergedEvent = Functions.mergeParallelFunctionResponseEvents(events);
            if (maybeMergedEvent.isEmpty()) {
                return Maybe.empty();
            }
            Event mergedEvent = maybeMergedEvent.get();
            if (events.size() > 1) {
                Tracer tracer = Telemetry.getTracer();
                Span mergedSpan = tracer.spanBuilder("tool_response").setParent(Context.current()).startSpan();
                try (Scope scope = mergedSpan.makeCurrent();){
                    Telemetry.traceToolResponse(invocationContext, mergedEvent.id(), mergedEvent);
                }
                finally {
                    mergedSpan.end();
                }
            }
            return Maybe.just((Object)mergedEvent);
        });
    }

    public static Maybe<Event> handleFunctionCallsLive(InvocationContext invocationContext, Event functionCallEvent, Map<String, BaseTool> tools) {
        ImmutableList<FunctionCall> functionCalls = functionCallEvent.functionCalls();
        for (FunctionCall functionCall2 : functionCalls) {
            if (tools.containsKey(functionCall2.name().get())) continue;
            throw new VerifyException("Tool not found: " + (String)functionCall2.name().get());
        }
        Function functionCallMapper = functionCall -> {
            BaseTool tool = (BaseTool)tools.get(functionCall.name().get());
            ToolContext toolContext = ToolContext.builder(invocationContext).functionCallId(functionCall.id().orElse("")).build();
            Map functionArgs = functionCall.args().orElse(new HashMap());
            Maybe maybeFunctionResult = Functions.maybeInvokeBeforeToolCall(invocationContext, tool, functionArgs, toolContext).switchIfEmpty((MaybeSource)Maybe.defer(() -> Functions.processFunctionLive(invocationContext, tool, toolContext, functionCall, functionArgs)));
            return maybeFunctionResult.map(Optional::of).defaultIfEmpty(Optional.empty()).onErrorResumeNext(t -> invocationContext.pluginManager().runOnToolErrorCallback(tool, functionArgs, toolContext, (Throwable)t).map(Optional::ofNullable).switchIfEmpty((SingleSource)Single.error((Throwable)t))).flatMapMaybe(optionalInitialResult -> {
                Map initialFunctionResult = optionalInitialResult.orElse(null);
                Maybe<Map<String, Object>> afterToolResultMaybe = Functions.maybeInvokeAfterToolCall(invocationContext, tool, functionArgs, toolContext, initialFunctionResult);
                return afterToolResultMaybe.map(Optional::of).defaultIfEmpty(Optional.ofNullable(initialFunctionResult)).flatMapMaybe(finalOptionalResult -> {
                    Map finalFunctionResult = finalOptionalResult.orElse(null);
                    if (tool.longRunning() && finalFunctionResult == null) {
                        return Maybe.empty();
                    }
                    Event functionResponseEvent = Functions.buildResponseEvent(tool, finalFunctionResult, toolContext, invocationContext);
                    return Maybe.just((Object)functionResponseEvent);
                });
            });
        };
        Flowable responseEventsFlowable = invocationContext.runConfig().toolExecutionMode() == RunConfig.ToolExecutionMode.SEQUENTIAL ? Flowable.fromIterable(functionCalls).concatMapMaybe(functionCallMapper) : Flowable.fromIterable(functionCalls).flatMapMaybe(functionCallMapper);
        return responseEventsFlowable.toList().flatMapMaybe(events -> {
            if (events.isEmpty()) {
                return Maybe.empty();
            }
            return Maybe.just((Object)Functions.mergeParallelFunctionResponseEvents(events).orElse(null));
        });
    }

    private static Maybe<Map<String, Object>> processFunctionLive(InvocationContext invocationContext, BaseTool tool, ToolContext toolContext, FunctionCall functionCall, Map<String, Object> args) {
        FunctionTool functionTool;
        if (((String)functionCall.name().get()).equals("stopStreaming") && args.containsKey("functionName")) {
            String functionNameToStop = (String)args.get("functionName");
            ActiveStreamingTool activeTool = invocationContext.activeStreamingTools().get(functionNameToStop);
            if (activeTool != null) {
                if (activeTool.task() != null && !activeTool.task().isDisposed()) {
                    activeTool.task().dispose();
                }
                if (activeTool.stream() != null) {
                    activeTool.stream().close();
                }
                invocationContext.activeStreamingTools().remove(functionNameToStop);
                logger.info("Successfully stopped streaming function {}", (Object)functionNameToStop);
                return Maybe.just((Object)ImmutableMap.of((Object)"status", (Object)("Successfully stopped streaming function " + functionNameToStop)));
            }
            logger.warn("No active streaming function named {} found to stop", (Object)functionNameToStop);
            return Maybe.just((Object)ImmutableMap.of((Object)"status", (Object)("No active streaming function named " + functionNameToStop)));
        }
        if (tool instanceof FunctionTool && (functionTool = (FunctionTool)tool).isStreaming()) {
            try {
                Flowable<Map<String, Object>> toolOutputStream = functionTool.callLive(args, toolContext, invocationContext);
                Disposable subscription = toolOutputStream.subscribe(result -> {
                    String resultText = "Function " + tool.name() + " returned: " + String.valueOf(result);
                    Content updateContent = Content.builder().role("user").parts(new Part[]{Part.fromText((String)resultText)}).build();
                    invocationContext.liveRequestQueue().get().content(updateContent);
                }, error -> logger.error("Error in streaming tool " + tool.name(), error.getCause()), () -> {
                    logger.info("Streaming tool {} completed.", (Object)tool.name());
                    invocationContext.activeStreamingTools().remove(tool.name());
                });
                ActiveStreamingTool activeTool = invocationContext.activeStreamingTools().getOrDefault(tool.name(), new ActiveStreamingTool(subscription));
                activeTool.task(subscription);
                invocationContext.activeStreamingTools().put(tool.name(), activeTool);
                return Maybe.just((Object)ImmutableMap.of((Object)"status", (Object)"The function is running asynchronously and the results are pending."));
            }
            catch (Exception e) {
                logger.error("Failed to start streaming tool: " + tool.name(), (Throwable)e);
                return Maybe.error((Throwable)e);
            }
        }
        return Functions.callTool(tool, args, toolContext);
    }

    public static Set<String> getLongRunningFunctionCalls(List<FunctionCall> functionCalls, Map<String, BaseTool> tools) {
        HashSet<String> longRunningFunctionCalls = new HashSet<String>();
        for (FunctionCall functionCall : functionCalls) {
            BaseTool tool;
            if (!tools.containsKey(functionCall.name().get()) || !(tool = tools.get(functionCall.name().get())).longRunning()) continue;
            longRunningFunctionCalls.add(functionCall.id().orElse(""));
        }
        return longRunningFunctionCalls;
    }

    private static Optional<Event> mergeParallelFunctionResponseEvents(List<Event> functionResponseEvents) {
        if (functionResponseEvents.isEmpty()) {
            return Optional.empty();
        }
        if (functionResponseEvents.size() == 1) {
            return Optional.of(functionResponseEvents.get(0));
        }
        Event baseEvent = functionResponseEvents.get(0);
        ArrayList mergedParts = new ArrayList();
        for (Event event : functionResponseEvents) {
            event.content().flatMap(Content::parts).ifPresent(mergedParts::addAll);
        }
        EventActions.Builder mergedActionsBuilder = EventActions.builder();
        for (Event event : functionResponseEvents) {
            mergedActionsBuilder.merge(event.actions());
        }
        return Optional.of(Event.builder().id(Event.generateEventId()).invocationId(baseEvent.invocationId()).author(baseEvent.author()).branch(baseEvent.branch()).content(Optional.of(Content.builder().role("user").parts(mergedParts).build())).actions(mergedActionsBuilder.build()).timestamp(baseEvent.timestamp()).build());
    }

    private static Maybe<Map<String, Object>> maybeInvokeBeforeToolCall(InvocationContext invocationContext, BaseTool tool, Map<String, Object> functionArgs, ToolContext toolContext) {
        if (invocationContext.agent() instanceof LlmAgent) {
            LlmAgent agent = (LlmAgent)invocationContext.agent();
            Maybe<Map<String, Object>> pluginResult = invocationContext.pluginManager().runBeforeToolCallback(tool, functionArgs, toolContext);
            Optional<List<? extends Callbacks.BeforeToolCallback>> callbacksOpt = agent.beforeToolCallback();
            if (callbacksOpt.isEmpty() || callbacksOpt.get().isEmpty()) {
                return pluginResult;
            }
            List<? extends Callbacks.BeforeToolCallback> callbacks = callbacksOpt.get();
            Maybe callbackResult = Maybe.defer(() -> Flowable.fromIterable((Iterable)callbacks).concatMapMaybe(callback -> callback.call(invocationContext, tool, functionArgs, toolContext)).firstElement());
            return pluginResult.switchIfEmpty((MaybeSource)callbackResult);
        }
        return Maybe.empty();
    }

    private static Maybe<Map<String, Object>> maybeInvokeAfterToolCall(InvocationContext invocationContext, BaseTool tool, Map<String, Object> functionArgs, ToolContext toolContext, Map<String, Object> functionResult) {
        if (invocationContext.agent() instanceof LlmAgent) {
            LlmAgent agent = (LlmAgent)invocationContext.agent();
            Maybe<Map<String, Object>> pluginResult = invocationContext.pluginManager().runAfterToolCallback(tool, functionArgs, toolContext, functionResult);
            Optional<List<? extends Callbacks.AfterToolCallback>> callbacksOpt = agent.afterToolCallback();
            if (callbacksOpt.isEmpty() || callbacksOpt.get().isEmpty()) {
                return pluginResult;
            }
            List<? extends Callbacks.AfterToolCallback> callbacks = callbacksOpt.get();
            Maybe callbackResult = Maybe.defer(() -> Flowable.fromIterable((Iterable)callbacks).concatMapMaybe(callback -> callback.call(invocationContext, tool, functionArgs, toolContext, functionResult)).firstElement());
            return pluginResult.switchIfEmpty((MaybeSource)callbackResult);
        }
        return Maybe.empty();
    }

    private static Maybe<Map<String, Object>> callTool(BaseTool tool, Map<String, Object> args, ToolContext toolContext) {
        Tracer tracer = Telemetry.getTracer();
        return Maybe.defer(() -> {
            Maybe maybe;
            block8: {
                Span span = tracer.spanBuilder("tool_call [" + tool.name() + "]").setParent(Context.current()).startSpan();
                Scope scope = span.makeCurrent();
                try {
                    Telemetry.traceToolCall(args);
                    maybe = tool.runAsync(args, toolContext).toMaybe().doOnError(arg_0 -> ((Span)span).recordException(arg_0)).doFinally(() -> ((Span)span).end());
                    if (scope == null) break block8;
                }
                catch (Throwable t$) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (RuntimeException e) {
                        span.recordException((Throwable)e);
                        span.end();
                        return Maybe.error((Throwable)new RuntimeException("Failed to call tool: " + tool.name(), e));
                    }
                }
                scope.close();
            }
            return maybe;
        });
    }

    private static Event buildResponseEvent(BaseTool tool, Map<String, Object> response, ToolContext toolContext, InvocationContext invocationContext) {
        Tracer tracer = Telemetry.getTracer();
        Span span = tracer.spanBuilder("tool_response [" + tool.name() + "]").setParent(Context.current()).startSpan();
        try {
            Event event;
            block10: {
                Scope scope = span.makeCurrent();
                try {
                    if (response == null) {
                        response = new HashMap<String, Object>();
                    }
                    Part partFunctionResponse = Part.builder().functionResponse(FunctionResponse.builder().id(toolContext.functionCallId().orElse("")).name(tool.name()).response(response).build()).build();
                    Event event2 = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author(invocationContext.agent().name()).branch(invocationContext.branch()).content(Optional.of(Content.builder().role("user").parts(Collections.singletonList(partFunctionResponse)).build())).actions(toolContext.eventActions()).build();
                    Telemetry.traceToolResponse(invocationContext, event2.id(), event2);
                    event = event2;
                    if (scope == null) break block10;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return event;
        }
        finally {
            span.end();
        }
    }

    public static Optional<Event> generateRequestConfirmationEvent(InvocationContext invocationContext, Event functionCallEvent, Event functionResponseEvent) {
        if (functionResponseEvent.actions().requestedToolConfirmations().isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        HashSet<String> longRunningToolIds = new HashSet<String>();
        ImmutableMap functionCallsById = (ImmutableMap)functionCallEvent.functionCalls().stream().filter(fc -> fc.id().isPresent()).collect(ImmutableMap.toImmutableMap(fc -> (String)fc.id().get(), fc -> fc));
        for (Map.Entry entry : ((ImmutableMap)functionResponseEvent.actions().requestedToolConfirmations().entrySet().stream().filter(fc -> functionCallsById.containsKey(fc.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).entrySet()) {
            FunctionCall requestConfirmationFunctionCall = FunctionCall.builder().name(REQUEST_CONFIRMATION_FUNCTION_CALL_NAME).args((Map)ImmutableMap.of((Object)"originalFunctionCall", (Object)functionCallsById.get(entry.getKey()), (Object)"toolConfirmation", entry.getValue())).id(Functions.generateClientFunctionCallId()).build();
            longRunningToolIds.add((String)requestConfirmationFunctionCall.id().get());
            parts.add(Part.builder().functionCall(requestConfirmationFunctionCall).build());
        }
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        Content.Builder contentBuilder = Content.builder().parts(parts);
        functionResponseEvent.content().flatMap(Content::role).ifPresent(arg_0 -> ((Content.Builder)contentBuilder).role(arg_0));
        return Optional.of(Event.builder().invocationId(invocationContext.invocationId()).author(invocationContext.agent().name()).branch(invocationContext.branch()).content(contentBuilder.build()).longRunningToolIds(longRunningToolIds).build());
    }

    private Functions() {
    }
}

