/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.Annotations;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Single;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AgentTransfer
implements RequestProcessor {
    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        BaseAgent baseAgent = context.agent();
        if (!(baseAgent instanceof LlmAgent)) {
            throw new IllegalArgumentException("Base agent in InvocationContext is not an instance of Agent.");
        }
        LlmAgent agent = (LlmAgent)baseAgent;
        List<BaseAgent> transferTargets = this.getTransferTargets(agent);
        if (transferTargets.isEmpty()) {
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(request, (Iterable<Event>)ImmutableList.of()));
        }
        LlmRequest.Builder builder = request.toBuilder().appendInstructions((List<String>)ImmutableList.of((Object)this.buildTargetAgentsInstructions(agent, transferTargets)));
        builder.appendTools((List<BaseTool>)ImmutableList.of((Object)this.createTransferToAgentTool("legacyTransferToAgent")));
        FunctionTool agentTransferTool = this.createTransferToAgentTool("transferToAgent");
        agentTransferTool.processLlmRequest(builder, ToolContext.builder(context).build());
        return Single.just((Object)RequestProcessor.RequestProcessingResult.create(builder.build(), (Iterable<Event>)ImmutableList.of()));
    }

    private FunctionTool createTransferToAgentTool(String methodName) {
        Method transferToAgentMethod;
        try {
            transferToAgentMethod = AgentTransfer.class.getMethod(methodName, String.class, ToolContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return FunctionTool.create(transferToAgentMethod);
    }

    private String buildTargetAgentsInfo(BaseAgent targetAgent) {
        return String.format("\nAgent name: %s\nAgent description: %s", targetAgent.name(), targetAgent.description());
    }

    private String buildTargetAgentsInstructions(LlmAgent agent, List<BaseAgent> transferTargets) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nYou have a list of other agents to transfer to:");
        sb.append("\n\n");
        ArrayList<CallSite> agentNames = new ArrayList<CallSite>();
        for (BaseAgent targetAgent : transferTargets) {
            agentNames.add((CallSite)((Object)("`" + targetAgent.name() + "`")));
            sb.append(this.buildTargetAgentsInfo(targetAgent));
            sb.append("\n\n");
        }
        sb.append("\nIf you are the best to answer the question according to your description, you\ncan answer it.\n\nIf another agent is better for answering the question according to its\ndescription, call `transfer_to_agent` function to transfer the\nquestion to that agent. When transferring, do not generate any text other than\nthe function call.\n\n**NOTE**: the only available agents for `transfer_to_agent` function are");
        sb.append(" ");
        agentNames.sort(String::compareTo);
        sb.append(String.join((CharSequence)", ", agentNames));
        sb.append(".\n");
        if (agent.parentAgent() != null && !agent.disallowTransferToParent()) {
            sb.append("\nIf neither you nor the other agents are best for the question, transfer to your parent agent ");
            sb.append(agent.parentAgent().name());
            sb.append(".\n");
        }
        return sb.toString();
    }

    private List<BaseAgent> getTransferTargets(LlmAgent agent) {
        ArrayList<BaseAgent> transferTargets = new ArrayList<BaseAgent>();
        transferTargets.addAll(agent.subAgents());
        BaseAgent parent = agent.parentAgent();
        if (!(parent instanceof LlmAgent)) {
            return transferTargets;
        }
        if (!agent.disallowTransferToParent()) {
            transferTargets.add(parent);
        }
        if (!agent.disallowTransferToPeers()) {
            for (BaseAgent baseAgent : parent.subAgents()) {
                if (baseAgent.name().equals(agent.name())) continue;
                transferTargets.add(baseAgent);
            }
        }
        return transferTargets;
    }

    @Annotations.Schema(name="transfer_to_agent", description="Transfer the question to another agent.\n\n  This tool hands off control to another agent when it's more suitable to\n  answer the user's question according to the agent's description.\n\n  Args:\n    agent_name: the agent name to transfer to.\n  ")
    public static void transferToAgent(@Annotations.Schema(name="agent_name") String agentName, @Annotations.Schema(optional=true) ToolContext toolContext) {
        EventActions eventActions = toolContext.eventActions();
        toolContext.setActions(eventActions.toBuilder().transferToAgent(agentName).build());
    }

    @Annotations.Schema(name="transferToAgent")
    public static void legacyTransferToAgent(@Annotations.Schema(name="agentName") String agentName, @Annotations.Schema(optional=true) ToolContext toolContext) {
        AgentTransfer.transferToAgent(agentName, toolContext);
    }
}

