/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.examples.BaseExampleProvider;
import com.google.adk.examples.Example;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import java.util.List;
import java.util.stream.Collectors;

public final class ExampleUtils {
    private static final String EXAMPLES_INTRO = "<EXAMPLES>\nBegin few-shot\nThe following are examples of user queries and model responses using the available tools.\n\n";
    private static final String EXAMPLES_END = "End few-shot\nNow, try to follow these examples and complete the following conversation\n<EXAMPLES>";
    private static final String EXAMPLE_START = "EXAMPLE %d:\nBegin example\n";
    private static final String EXAMPLE_END = "End example\n\n";
    private static final String USER_PREFIX = "[user]\n";
    private static final String MODEL_PREFIX = "[model]\n";
    private static final String FUNCTION_CALL_PREFIX = "```tool_code\n";
    private static final String FUNCTION_CALL_SUFFIX = "\n```\n";
    private static final String FUNCTION_RESPONSE_PREFIX = "```tool_outputs\n";
    private static final String FUNCTION_RESPONSE_SUFFIX = "\n```\n";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static String convertExamplesToText(List<Example> examples) {
        StringBuilder examplesStr = new StringBuilder();
        examplesStr.append(EXAMPLES_INTRO);
        for (int i = 0; i < examples.size(); ++i) {
            Example example = examples.get(i);
            examplesStr.append(String.format(EXAMPLE_START, i + 1));
            ExampleUtils.appendInput(example, examplesStr);
            for (Content content : example.output()) {
                ExampleUtils.appendOutput(content, examplesStr);
            }
            examplesStr.append(EXAMPLE_END);
        }
        examplesStr.append(EXAMPLES_END);
        return examplesStr.toString();
    }

    private static void appendInput(Example example, StringBuilder builder) {
        example.input().parts().flatMap(parts -> parts.stream().findFirst().flatMap(Part::text)).ifPresent(text -> builder.append(USER_PREFIX).append((String)text).append("\n\n"));
    }

    private static void appendOutput(Content output, StringBuilder builder) {
        String rolePrefix = output.role().orElse("").equals("model") ? MODEL_PREFIX : USER_PREFIX;
        for (Part part : (List)output.parts().orElse(ImmutableList.of())) {
            if (part.functionCall().isPresent()) {
                ExampleUtils.appendFunctionCall((FunctionCall)part.functionCall().get(), rolePrefix, builder);
                continue;
            }
            if (part.functionResponse().isPresent()) {
                ExampleUtils.appendFunctionResponse((FunctionResponse)part.functionResponse().get(), builder);
                continue;
            }
            if (!part.text().isPresent()) continue;
            builder.append(rolePrefix).append((String)part.text().get()).append("\n");
        }
    }

    private static void appendFunctionCall(FunctionCall functionCall, String rolePrefix, StringBuilder builder) {
        String argsString = functionCall.args().stream().flatMap(argsMap -> argsMap.entrySet().stream()).map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                return String.format("%s='%s'", key, value);
            }
            return String.format("%s=%s", key, value);
        }).collect(Collectors.joining(", "));
        builder.append(rolePrefix).append(FUNCTION_CALL_PREFIX).append(functionCall.name().orElse("")).append("(").append(argsString).append(")").append("\n```\n");
    }

    private static void appendFunctionResponse(FunctionResponse response, StringBuilder builder) {
        try {
            ImmutableMap responseMap = response.response().orElse(ImmutableMap.of());
            builder.append(FUNCTION_RESPONSE_PREFIX).append(OBJECT_MAPPER.writeValueAsString((Object)responseMap)).append("\n```\n");
        }
        catch (JsonProcessingException e) {
            builder.append(FUNCTION_RESPONSE_PREFIX).append("\n```\n");
        }
    }

    public static String buildExampleSi(BaseExampleProvider exampleProvider, String query) {
        return ExampleUtils.convertExamplesToText(exampleProvider.getExamples(query));
    }

    private ExampleUtils() {
    }
}

