/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.BaseAgentConfig;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.LlmAgentConfig;
import com.google.adk.agents.ParallelAgent;
import com.google.adk.agents.ParallelAgentConfig;
import com.google.adk.agents.SequentialAgent;
import com.google.adk.agents.SequentialAgentConfig;
import com.google.adk.agents.YamlPreprocessor;
import com.google.adk.utils.ComponentRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigAgentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAgentUtils.class);

    private ConfigAgentUtils() {
    }

    public static void resolveAndSetCommonAgentFields(BaseAgent.Builder<?> builder, BaseAgentConfig config, String configAbsPath) throws ConfigurationException {
        if (config.name() == null || config.name().trim().isEmpty()) {
            throw new ConfigurationException("Agent name is required");
        }
        builder.name(config.name());
        builder.description(Strings.nullToEmpty((String)config.description()));
        if (config.subAgents() != null && !config.subAgents().isEmpty()) {
            builder.subAgents((List<BaseAgent>)ConfigAgentUtils.resolveSubAgents(config.subAgents(), configAbsPath));
        }
        ConfigAgentUtils.setBaseAgentCallbacks(config, builder::beforeAgentCallback, builder::afterAgentCallback);
    }

    public static <T> void resolveAndSetCallback(@Nullable List<BaseAgentConfig.CallbackRef> refs, Class<T> callbackBaseClass, String callbackTypeName, Consumer<ImmutableList<T>> builderSetter) throws ConfigurationException {
        if (refs != null) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (BaseAgentConfig.CallbackRef ref : refs) {
                list.add(ComponentRegistry.getInstance().get(ref.name(), callbackBaseClass).orElseThrow(() -> new ConfigurationException("Invalid " + callbackTypeName + ": " + ref.name())));
            }
            builderSetter.accept(list.build());
        }
    }

    public static void setBaseAgentCallbacks(BaseAgentConfig config, Consumer<ImmutableList<Callbacks.BeforeAgentCallbackBase>> beforeSetter, Consumer<ImmutableList<Callbacks.AfterAgentCallbackBase>> afterSetter) throws ConfigurationException {
        ConfigAgentUtils.resolveAndSetCallback(config.beforeAgentCallbacks(), Callbacks.BeforeAgentCallbackBase.class, "before_agent_callback", beforeSetter);
        ConfigAgentUtils.resolveAndSetCallback(config.afterAgentCallbacks(), Callbacks.AfterAgentCallbackBase.class, "after_agent_callback", afterSetter);
    }

    public static BaseAgent fromConfig(String configPath) throws ConfigurationException {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            logger.error("Config file not found: {}", (Object)configPath);
            throw new ConfigurationException("Config file not found: " + configPath);
        }
        String absolutePath = configFile.getAbsolutePath();
        try {
            BaseAgentConfig baseConfig = ConfigAgentUtils.loadConfigAsType(absolutePath, BaseAgentConfig.class);
            Class<? extends BaseAgent> agentClass = ComponentRegistry.resolveAgentClass(baseConfig.agentClass());
            Class<? extends BaseAgentConfig> configClass = ConfigAgentUtils.getConfigClassForAgent(agentClass);
            BaseAgentConfig config = ConfigAgentUtils.loadConfigAsType(absolutePath, configClass);
            logger.info("agentClass value = '{}'", (Object)config.agentClass());
            logger.info("configClass value = '{}'", (Object)configClass.getName());
            Method fromConfigMethod = agentClass.getDeclaredMethod("fromConfig", configClass, String.class);
            return (BaseAgent)fromConfigMethod.invoke(null, config, absolutePath);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create agent from config: " + configPath, e);
        }
    }

    public static ImmutableList<BaseAgent> resolveSubAgents(List<BaseAgentConfig.AgentRefConfig> subAgentConfigs, String configAbsPath) throws ConfigurationException {
        if (subAgentConfigs == null || subAgentConfigs.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<BaseAgent> resolvedSubAgents = new ArrayList<BaseAgent>();
        Path configDir = Paths.get(configAbsPath, new String[0]).getParent();
        for (BaseAgentConfig.AgentRefConfig subAgentConfig : subAgentConfigs) {
            try {
                BaseAgent subAgent = ConfigAgentUtils.resolveSubAgent(subAgentConfig, configDir);
                resolvedSubAgents.add(subAgent);
                logger.debug("Successfully resolved subagent: {}", (Object)subAgent.name());
            }
            catch (Exception e) {
                String errorMsg = "Failed to resolve subagent";
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigurationException(errorMsg, e);
            }
        }
        return ImmutableList.copyOf(resolvedSubAgents);
    }

    private static BaseAgent resolveSubAgent(BaseAgentConfig.AgentRefConfig subAgentConfig, Path configDir) throws ConfigurationException {
        if (subAgentConfig.configPath() != null && !subAgentConfig.configPath().trim().isEmpty()) {
            return ConfigAgentUtils.resolveSubAgentFromConfigPath(subAgentConfig, configDir);
        }
        if (subAgentConfig.code() != null && !subAgentConfig.code().trim().isEmpty()) {
            String registryKey = subAgentConfig.code().trim();
            return ComponentRegistry.resolveAgentInstance(registryKey).orElseThrow(() -> new ConfigurationException("Failed to resolve subagent from registry with code key: " + registryKey));
        }
        throw new ConfigurationException("Subagent configuration must specify either 'configPath' or 'code'.");
    }

    private static BaseAgent resolveSubAgentFromConfigPath(BaseAgentConfig.AgentRefConfig subAgentConfig, Path configDir) throws ConfigurationException {
        String configPath = subAgentConfig.configPath().trim();
        Path subAgentConfigPath = Path.of(configPath, new String[0]).isAbsolute() ? Path.of(configPath, new String[0]) : configDir.resolve(configPath);
        if (!Files.exists(subAgentConfigPath, new LinkOption[0])) {
            throw new ConfigurationException("Subagent config file not found: " + String.valueOf(subAgentConfigPath));
        }
        try {
            return ConfigAgentUtils.fromConfig(subAgentConfigPath.toString());
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to load subagent from config: " + String.valueOf(subAgentConfigPath), e);
        }
    }

    private static <T extends BaseAgentConfig> T loadConfigAsType(String configPath, Class<T> configClass) throws ConfigurationException {
        try {
            String yamlContent = Files.readString(Paths.get(configPath, new String[0]), StandardCharsets.UTF_8);
            String processedYaml = YamlPreprocessor.preprocessYaml(yamlContent);
            ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
            return (T)((BaseAgentConfig)mapper.readValue(processedYaml, configClass));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load or parse config file: " + configPath, e);
        }
    }

    private static Class<? extends BaseAgentConfig> getConfigClassForAgent(Class<? extends BaseAgent> agentClass) {
        if (agentClass == LlmAgent.class) {
            return LlmAgentConfig.class;
        }
        if (agentClass == SequentialAgent.class) {
            return SequentialAgentConfig.class;
        }
        if (agentClass == ParallelAgent.class) {
            return ParallelAgentConfig.class;
        }
        return BaseAgentConfig.class;
    }

    public static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

