/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.Callbacks;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Maybe;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallbackUtil {
    private static final Logger logger = LoggerFactory.getLogger(CallbackUtil.class);

    @CanIgnoreReturnValue
    public static @Nullable ImmutableList<Callbacks.BeforeAgentCallback> getBeforeAgentCallbacks(List<Callbacks.BeforeAgentCallbackBase> beforeAgentCallback) {
        if (beforeAgentCallback == null) {
            return null;
        }
        if (beforeAgentCallback.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Callbacks.BeforeAgentCallbackBase callback : beforeAgentCallback) {
            if (callback instanceof Callbacks.BeforeAgentCallback) {
                Callbacks.BeforeAgentCallback beforeAgentCallbackInstance = (Callbacks.BeforeAgentCallback)callback;
                builder.add((Object)beforeAgentCallbackInstance);
                continue;
            }
            if (callback instanceof Callbacks.BeforeAgentCallbackSync) {
                Callbacks.BeforeAgentCallbackSync beforeAgentCallbackSyncInstance = (Callbacks.BeforeAgentCallbackSync)callback;
                builder.add(callbackContext -> Maybe.fromOptional(beforeAgentCallbackSyncInstance.call(callbackContext)));
                continue;
            }
            logger.warn("Invalid beforeAgentCallback callback type: %s. Ignoring this callback.", (Object)callback.getClass().getName());
        }
        return builder.build();
    }

    @CanIgnoreReturnValue
    public static @Nullable ImmutableList<Callbacks.AfterAgentCallback> getAfterAgentCallbacks(List<Callbacks.AfterAgentCallbackBase> afterAgentCallback) {
        if (afterAgentCallback == null) {
            return null;
        }
        if (afterAgentCallback.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Callbacks.AfterAgentCallbackBase callback : afterAgentCallback) {
            if (callback instanceof Callbacks.AfterAgentCallback) {
                Callbacks.AfterAgentCallback afterAgentCallbackInstance = (Callbacks.AfterAgentCallback)callback;
                builder.add((Object)afterAgentCallbackInstance);
                continue;
            }
            if (callback instanceof Callbacks.AfterAgentCallbackSync) {
                Callbacks.AfterAgentCallbackSync afterAgentCallbackSyncInstance = (Callbacks.AfterAgentCallbackSync)callback;
                builder.add(callbackContext -> Maybe.fromOptional(afterAgentCallbackSyncInstance.call(callbackContext)));
                continue;
            }
            logger.warn("Invalid afterAgentCallback callback type: %s. Ignoring this callback.", (Object)callback.getClass().getName());
        }
        return builder.build();
    }

    private CallbackUtil() {
    }
}

