/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.Content;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Telemetry {
    private static final Logger log = LoggerFactory.getLogger(Telemetry.class);
    private static Tracer tracer = GlobalOpenTelemetry.getTracer((String)"gcp.vertex.agent");

    private Telemetry() {
    }

    public static void setTracerForTesting(Tracer tracer) {
        Telemetry.tracer = tracer;
    }

    public static void traceToolCall(Map<String, Object> args) {
        Span span = Span.current();
        if (span == null || !span.getSpanContext().isValid()) {
            log.trace("traceToolCall: No valid span in current context.");
            return;
        }
        span.setAttribute("gen_ai.system", "gcp.vertex.agent");
        try {
            span.setAttribute("gcp.vertex.agent.tool_call_args", JsonBaseModel.getMapper().writeValueAsString(args));
        }
        catch (JsonProcessingException e) {
            log.warn("traceToolCall: Failed to serialize tool call args to JSON", (Throwable)e);
        }
    }

    public static void traceToolResponse(InvocationContext invocationContext, String eventId, Event functionResponseEvent) {
        Span span = Span.current();
        if (span == null || !span.getSpanContext().isValid()) {
            log.trace("traceToolResponse: No valid span in current context.");
            return;
        }
        span.setAttribute("gen_ai.system", "gcp.vertex.agent");
        span.setAttribute("gcp.vertex.agent.invocation_id", invocationContext.invocationId());
        span.setAttribute("gcp.vertex.agent.event_id", eventId);
        span.setAttribute("gcp.vertex.agent.tool_response", functionResponseEvent.toJson());
        span.setAttribute("gcp.vertex.agent.llm_request", "{}");
        span.setAttribute("gcp.vertex.agent.llm_response", "{}");
        if (invocationContext.session() != null && invocationContext.session().id() != null) {
            span.setAttribute("gcp.vertex.agent.session_id", invocationContext.session().id());
        }
    }

    private static Map<String, Object> buildLlmRequestForTrace(LlmRequest llmRequest) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("model", llmRequest.model().orElse(null));
        llmRequest.config().ifPresent(config -> result.put("config", config));
        ArrayList<Content> contentsList = new ArrayList<Content>();
        for (Content content : llmRequest.contents()) {
            ImmutableList filteredParts = (ImmutableList)((List)content.parts().orElse(ImmutableList.of())).stream().filter(part -> part.inlineData().isEmpty()).collect(ImmutableList.toImmutableList());
            Content.Builder contentBuilder = Content.builder();
            content.role().ifPresent(arg_0 -> ((Content.Builder)contentBuilder).role(arg_0));
            contentBuilder.parts((List)filteredParts);
            contentsList.add(contentBuilder.build());
        }
        result.put("contents", contentsList);
        return result;
    }

    public static void traceCallLlm(InvocationContext invocationContext, String eventId, LlmRequest llmRequest, LlmResponse llmResponse) {
        Span span = Span.current();
        if (span == null || !span.getSpanContext().isValid()) {
            log.trace("traceCallLlm: No valid span in current context.");
            return;
        }
        span.setAttribute("gen_ai.system", "gcp.vertex.agent");
        llmRequest.model().ifPresent(modelName -> span.setAttribute("gen_ai.request.model", modelName));
        span.setAttribute("gcp.vertex.agent.invocation_id", invocationContext.invocationId());
        span.setAttribute("gcp.vertex.agent.event_id", eventId);
        if (invocationContext.session() != null && invocationContext.session().id() != null) {
            span.setAttribute("gcp.vertex.agent.session_id", invocationContext.session().id());
        } else {
            log.trace("traceCallLlm: InvocationContext session or session ID is null, cannot set gcp.vertex.agent.session_id");
        }
        try {
            span.setAttribute("gcp.vertex.agent.llm_request", JsonBaseModel.getMapper().writeValueAsString(Telemetry.buildLlmRequestForTrace(llmRequest)));
            span.setAttribute("gcp.vertex.agent.llm_response", llmResponse.toJson());
        }
        catch (JsonProcessingException e) {
            log.warn("traceCallLlm: Failed to serialize LlmRequest or LlmResponse to JSON", (Throwable)e);
        }
    }

    public static void traceSendData(InvocationContext invocationContext, String eventId, List<Content> data) {
        Span span = Span.current();
        if (span == null || !span.getSpanContext().isValid()) {
            log.trace("traceSendData: No valid span in current context.");
            return;
        }
        span.setAttribute("gcp.vertex.agent.invocation_id", invocationContext.invocationId());
        if (eventId != null && !eventId.isEmpty()) {
            span.setAttribute("gcp.vertex.agent.event_id", eventId);
        }
        if (invocationContext.session() != null && invocationContext.session().id() != null) {
            span.setAttribute("gcp.vertex.agent.session_id", invocationContext.session().id());
        }
        try {
            ArrayList<Map> dataList = new ArrayList<Map>();
            if (data != null) {
                for (Content content : data) {
                    if (content == null) continue;
                    dataList.add((Map)JsonBaseModel.getMapper().convertValue((Object)content, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
            }
            span.setAttribute("gcp.vertex.agent.data", JsonBaseModel.toJsonString(dataList));
        }
        catch (IllegalStateException e) {
            log.warn("traceSendData: Failed to serialize data to JSON", (Throwable)e);
        }
    }

    public static Tracer getTracer() {
        return tracer;
    }

    public static <T> Flowable<T> traceFlowable(Context spanContext, Span span, Supplier<Flowable<T>> flowableSupplier) {
        Scope scope = spanContext.makeCurrent();
        return flowableSupplier.get().doFinally(() -> {
            scope.close();
            span.end();
        });
    }
}

