package com.google.adk.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.GroundingMetadata;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LlmResponse extends LlmResponse {

  private final Optional<Content> content;

  private final Optional<GroundingMetadata> groundingMetadata;

  private final Optional<Boolean> partial;

  private final Optional<Boolean> turnComplete;

  private final Optional<FinishReason> errorCode;

  private final Optional<FinishReason> finishReason;

  private final Optional<Double> avgLogprobs;

  private final Optional<String> errorMessage;

  private final Optional<Boolean> interrupted;

  private final Optional<GenerateContentResponseUsageMetadata> usageMetadata;

  private final Optional<String> modelVersion;

  private AutoValue_LlmResponse(
      Optional<Content> content,
      Optional<GroundingMetadata> groundingMetadata,
      Optional<Boolean> partial,
      Optional<Boolean> turnComplete,
      Optional<FinishReason> errorCode,
      Optional<FinishReason> finishReason,
      Optional<Double> avgLogprobs,
      Optional<String> errorMessage,
      Optional<Boolean> interrupted,
      Optional<GenerateContentResponseUsageMetadata> usageMetadata,
      Optional<String> modelVersion) {
    this.content = content;
    this.groundingMetadata = groundingMetadata;
    this.partial = partial;
    this.turnComplete = turnComplete;
    this.errorCode = errorCode;
    this.finishReason = finishReason;
    this.avgLogprobs = avgLogprobs;
    this.errorMessage = errorMessage;
    this.interrupted = interrupted;
    this.usageMetadata = usageMetadata;
    this.modelVersion = modelVersion;
  }

  @JsonProperty("content")
  @Override
  public Optional<Content> content() {
    return content;
  }

  @JsonProperty("groundingMetadata")
  @Override
  public Optional<GroundingMetadata> groundingMetadata() {
    return groundingMetadata;
  }

  @JsonProperty("partial")
  @Override
  public Optional<Boolean> partial() {
    return partial;
  }

  @JsonProperty("turnComplete")
  @Override
  public Optional<Boolean> turnComplete() {
    return turnComplete;
  }

  @JsonProperty("errorCode")
  @Override
  public Optional<FinishReason> errorCode() {
    return errorCode;
  }

  @JsonProperty("finishReason")
  @Override
  public Optional<FinishReason> finishReason() {
    return finishReason;
  }

  @JsonProperty("avgLogprobs")
  @Override
  public Optional<Double> avgLogprobs() {
    return avgLogprobs;
  }

  @JsonProperty("errorMessage")
  @Override
  public Optional<String> errorMessage() {
    return errorMessage;
  }

  @JsonProperty("interrupted")
  @Override
  public Optional<Boolean> interrupted() {
    return interrupted;
  }

  @JsonProperty("usageMetadata")
  @Override
  public Optional<GenerateContentResponseUsageMetadata> usageMetadata() {
    return usageMetadata;
  }

  @JsonProperty("modelVersion")
  @Override
  public Optional<String> modelVersion() {
    return modelVersion;
  }

  @Override
  public String toString() {
    return "LlmResponse{"
        + "content=" + content + ", "
        + "groundingMetadata=" + groundingMetadata + ", "
        + "partial=" + partial + ", "
        + "turnComplete=" + turnComplete + ", "
        + "errorCode=" + errorCode + ", "
        + "finishReason=" + finishReason + ", "
        + "avgLogprobs=" + avgLogprobs + ", "
        + "errorMessage=" + errorMessage + ", "
        + "interrupted=" + interrupted + ", "
        + "usageMetadata=" + usageMetadata + ", "
        + "modelVersion=" + modelVersion
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LlmResponse) {
      LlmResponse that = (LlmResponse) o;
      return this.content.equals(that.content())
          && this.groundingMetadata.equals(that.groundingMetadata())
          && this.partial.equals(that.partial())
          && this.turnComplete.equals(that.turnComplete())
          && this.errorCode.equals(that.errorCode())
          && this.finishReason.equals(that.finishReason())
          && this.avgLogprobs.equals(that.avgLogprobs())
          && this.errorMessage.equals(that.errorMessage())
          && this.interrupted.equals(that.interrupted())
          && this.usageMetadata.equals(that.usageMetadata())
          && this.modelVersion.equals(that.modelVersion());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= content.hashCode();
    h$ *= 1000003;
    h$ ^= groundingMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= partial.hashCode();
    h$ *= 1000003;
    h$ ^= turnComplete.hashCode();
    h$ *= 1000003;
    h$ ^= errorCode.hashCode();
    h$ *= 1000003;
    h$ ^= finishReason.hashCode();
    h$ *= 1000003;
    h$ ^= avgLogprobs.hashCode();
    h$ *= 1000003;
    h$ ^= errorMessage.hashCode();
    h$ *= 1000003;
    h$ ^= interrupted.hashCode();
    h$ *= 1000003;
    h$ ^= usageMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= modelVersion.hashCode();
    return h$;
  }

  @Override
  public LlmResponse.Builder toBuilder() {
    return new AutoValue_LlmResponse.Builder(this);
  }

  static final class Builder extends LlmResponse.Builder {
    private Optional<Content> content = Optional.empty();
    private Optional<GroundingMetadata> groundingMetadata = Optional.empty();
    private Optional<Boolean> partial = Optional.empty();
    private Optional<Boolean> turnComplete = Optional.empty();
    private Optional<FinishReason> errorCode = Optional.empty();
    private Optional<FinishReason> finishReason = Optional.empty();
    private Optional<Double> avgLogprobs = Optional.empty();
    private Optional<String> errorMessage = Optional.empty();
    private Optional<Boolean> interrupted = Optional.empty();
    private Optional<GenerateContentResponseUsageMetadata> usageMetadata = Optional.empty();
    private Optional<String> modelVersion = Optional.empty();
    Builder() {
    }
    Builder(LlmResponse source) {
      this.content = source.content();
      this.groundingMetadata = source.groundingMetadata();
      this.partial = source.partial();
      this.turnComplete = source.turnComplete();
      this.errorCode = source.errorCode();
      this.finishReason = source.finishReason();
      this.avgLogprobs = source.avgLogprobs();
      this.errorMessage = source.errorMessage();
      this.interrupted = source.interrupted();
      this.usageMetadata = source.usageMetadata();
      this.modelVersion = source.modelVersion();
    }
    @Override
    public LlmResponse.Builder content(Content content) {
      this.content = Optional.of(content);
      return this;
    }
    @Override
    public LlmResponse.Builder content(Optional<Content> content) {
      if (content == null) {
        throw new NullPointerException("Null content");
      }
      this.content = content;
      return this;
    }
    @Override
    public LlmResponse.Builder groundingMetadata(@Nullable GroundingMetadata groundingMetadata) {
      this.groundingMetadata = Optional.ofNullable(groundingMetadata);
      return this;
    }
    @Override
    public LlmResponse.Builder groundingMetadata(Optional<GroundingMetadata> groundingMetadata) {
      if (groundingMetadata == null) {
        throw new NullPointerException("Null groundingMetadata");
      }
      this.groundingMetadata = groundingMetadata;
      return this;
    }
    @Override
    public LlmResponse.Builder partial(@Nullable Boolean partial) {
      this.partial = Optional.ofNullable(partial);
      return this;
    }
    @Override
    public LlmResponse.Builder partial(Optional<Boolean> partial) {
      if (partial == null) {
        throw new NullPointerException("Null partial");
      }
      this.partial = partial;
      return this;
    }
    @Override
    public LlmResponse.Builder turnComplete(@Nullable Boolean turnComplete) {
      this.turnComplete = Optional.ofNullable(turnComplete);
      return this;
    }
    @Override
    public LlmResponse.Builder turnComplete(Optional<Boolean> turnComplete) {
      if (turnComplete == null) {
        throw new NullPointerException("Null turnComplete");
      }
      this.turnComplete = turnComplete;
      return this;
    }
    @Override
    public LlmResponse.Builder errorCode(@Nullable FinishReason errorCode) {
      this.errorCode = Optional.ofNullable(errorCode);
      return this;
    }
    @Override
    public LlmResponse.Builder errorCode(Optional<FinishReason> errorCode) {
      if (errorCode == null) {
        throw new NullPointerException("Null errorCode");
      }
      this.errorCode = errorCode;
      return this;
    }
    @Override
    public LlmResponse.Builder finishReason(@Nullable FinishReason finishReason) {
      this.finishReason = Optional.ofNullable(finishReason);
      return this;
    }
    @Override
    public LlmResponse.Builder finishReason(Optional<FinishReason> finishReason) {
      if (finishReason == null) {
        throw new NullPointerException("Null finishReason");
      }
      this.finishReason = finishReason;
      return this;
    }
    @Override
    public LlmResponse.Builder avgLogprobs(@Nullable Double avgLogprobs) {
      this.avgLogprobs = Optional.ofNullable(avgLogprobs);
      return this;
    }
    @Override
    public LlmResponse.Builder avgLogprobs(Optional<Double> avgLogprobs) {
      if (avgLogprobs == null) {
        throw new NullPointerException("Null avgLogprobs");
      }
      this.avgLogprobs = avgLogprobs;
      return this;
    }
    @Override
    public LlmResponse.Builder errorMessage(@Nullable String errorMessage) {
      this.errorMessage = Optional.ofNullable(errorMessage);
      return this;
    }
    @Override
    public LlmResponse.Builder errorMessage(Optional<String> errorMessage) {
      if (errorMessage == null) {
        throw new NullPointerException("Null errorMessage");
      }
      this.errorMessage = errorMessage;
      return this;
    }
    @Override
    public LlmResponse.Builder interrupted(@Nullable Boolean interrupted) {
      this.interrupted = Optional.ofNullable(interrupted);
      return this;
    }
    @Override
    public LlmResponse.Builder interrupted(Optional<Boolean> interrupted) {
      if (interrupted == null) {
        throw new NullPointerException("Null interrupted");
      }
      this.interrupted = interrupted;
      return this;
    }
    @Override
    public LlmResponse.Builder usageMetadata(@Nullable GenerateContentResponseUsageMetadata usageMetadata) {
      this.usageMetadata = Optional.ofNullable(usageMetadata);
      return this;
    }
    @Override
    public LlmResponse.Builder usageMetadata(Optional<GenerateContentResponseUsageMetadata> usageMetadata) {
      if (usageMetadata == null) {
        throw new NullPointerException("Null usageMetadata");
      }
      this.usageMetadata = usageMetadata;
      return this;
    }
    @Override
    public LlmResponse.Builder modelVersion(@Nullable String modelVersion) {
      this.modelVersion = Optional.ofNullable(modelVersion);
      return this;
    }
    @Override
    public LlmResponse.Builder modelVersion(Optional<String> modelVersion) {
      if (modelVersion == null) {
        throw new NullPointerException("Null modelVersion");
      }
      this.modelVersion = modelVersion;
      return this;
    }
    @Override
    LlmResponse autoBuild() {
      return new AutoValue_LlmResponse(
          this.content,
          this.groundingMetadata,
          this.partial,
          this.turnComplete,
          this.errorCode,
          this.finishReason,
          this.avgLogprobs,
          this.errorMessage,
          this.interrupted,
          this.usageMetadata,
          this.modelVersion);
    }
  }

}
