/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.ToolContext;
import com.google.adk.tools.mcp.AbstractMcpTool;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.common.collect.ImmutableMap;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpTool
extends AbstractMcpTool<McpSyncClient> {
    private static final Logger logger = LoggerFactory.getLogger(McpTool.class);

    public McpTool(McpSchema.Tool mcpTool, McpSyncClient mcpSession, McpSessionManager mcpSessionManager) {
        super(mcpTool, mcpSession, mcpSessionManager, JsonBaseModel.getMapper());
    }

    public McpTool(McpSchema.Tool mcpTool, McpSyncClient mcpSession, McpSessionManager mcpSessionManager, ObjectMapper objectMapper) {
        super(mcpTool, mcpSession, mcpSessionManager, objectMapper);
    }

    private void reinitializeSession() {
        this.mcpSession = this.mcpSessionManager.createSession();
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        return Single.fromCallable(() -> {
            McpSchema.CallToolResult callResult = ((McpSyncClient)this.mcpSession).callTool(new McpSchema.CallToolRequest(this.name(), (Map)ImmutableMap.copyOf((Map)args)));
            return McpTool.wrapCallResult(this.objectMapper, this.name(), callResult);
        }).retryWhen(errors -> errors.delay(100L, TimeUnit.MILLISECONDS).take(3L).doOnNext(error -> {
            logger.error("Retrying callTool due to: {}", (Object)error.getMessage(), error);
            this.reinitializeSession();
        }));
    }
}

