/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.agents.InvocationContext;
import com.google.adk.codeexecutors.BaseCodeExecutor;
import com.google.adk.codeexecutors.CodeExecutionUtils;
import com.google.cloud.aiplatform.v1beta1.ExecuteExtensionRequest;
import com.google.cloud.aiplatform.v1beta1.ExecuteExtensionResponse;
import com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceClient;
import com.google.cloud.aiplatform.v1beta1.ExtensionExecutionServiceSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VertexAiCodeExecutor
extends BaseCodeExecutor {
    private static final Logger logger = Logger.getLogger(VertexAiCodeExecutor.class.getName());
    private static final ImmutableList<String> SUPPORTED_IMAGE_TYPES = ImmutableList.of((Object)"png", (Object)"jpg", (Object)"jpeg");
    private static final ImmutableList<String> SUPPORTED_DATA_FILE_TYPES = ImmutableList.of((Object)"csv");
    private static final String IMPORTED_LIBRARIES = "import io\nimport math\nimport re\n\nimport matplotlib.pyplot as plt\nimport numpy as np\nimport pandas as pd\nimport scipy\n\ndef crop(s: str, max_chars: int = 64) -> str:\n  \"\"\"Crops a string to max_chars characters.\"\"\"\n  return s[: max_chars - 3] + '...' if len(s) > max_chars else s\n\n\ndef explore_df(df: pd.DataFrame) -> None:\n  \"\"\"Prints some information about a pandas DataFrame.\"\"\"\n\n  with pd.option_context(\n      'display.max_columns', None, 'display.expand_frame_repr', False\n  ):\n    # Print the column names to never encounter KeyError when selecting one.\n    df_dtypes = df.dtypes\n\n    # Obtain information about data types and missing values.\n    df_nulls = (len(df) - df.isnull().sum()).apply(\n        lambda x: f'{x} / {df.shape[0]} non-null'\n    )\n\n    # Explore unique total values in columns using `.unique()`.\n    df_unique_count = df.apply(lambda x: len(x.unique()))\n\n    # Explore unique values in columns using `.unique()`.\n    df_unique = df.apply(lambda x: crop(str(list(x.unique()))))\n\n    df_info = pd.concat(\n        (\n            df_dtypes.rename('Dtype'),\n            df_nulls.rename('Non-Null Count'),\n            df_unique_count.rename('Unique Values Count'),\n            df_unique.rename('Unique Values'),\n        ),\n        axis=1,\n    )\n    df_info.index.name = 'Columns'\n    print(f\"\"\"Total rows: {df.shape[0]}\nTotal columns: {df.shape[1]}\n\n{df_info}\"\"\")";
    private final String resourceName;
    private final ExtensionExecutionServiceClient codeInterpreterExtension;

    public VertexAiCodeExecutor(String resourceName) {
        String resolvedResourceName = resourceName;
        if (resolvedResourceName == null || resolvedResourceName.isEmpty()) {
            resolvedResourceName = System.getenv("CODE_INTERPRETER_EXTENSION_NAME");
        }
        if (resolvedResourceName == null || resolvedResourceName.isEmpty()) {
            logger.warning("No resource name found for Vertex AI Code Interpreter. It will not be available.");
            this.resourceName = null;
            this.codeInterpreterExtension = null;
        } else {
            this.resourceName = resolvedResourceName;
            try {
                String[] parts = this.resourceName.split("/");
                if (parts.length < 4 || !parts[2].equals("locations")) {
                    throw new IllegalArgumentException("Invalid resource name format: " + this.resourceName);
                }
                String location = parts[3];
                String endpoint = String.format("%s-aiplatform.googleapis.com:443", location);
                ExtensionExecutionServiceSettings settings = ((ExtensionExecutionServiceSettings.Builder)ExtensionExecutionServiceSettings.newBuilder().setEndpoint(endpoint)).build();
                this.codeInterpreterExtension = ExtensionExecutionServiceClient.create((ExtensionExecutionServiceSettings)settings);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to create ExtensionExecutionServiceClient", e);
                throw new IllegalStateException("Failed to create ExtensionExecutionServiceClient", e);
            }
        }
    }

    @Override
    public CodeExecutionUtils.CodeExecutionResult executeCode(InvocationContext invocationContext, CodeExecutionUtils.CodeExecutionInput codeExecutionInput) {
        Map<String, Object> codeExecutionResult = this.executeCodeInterpreter(this.getCodeWithImports(codeExecutionInput.code()), (List<CodeExecutionUtils.File>)codeExecutionInput.inputFiles(), codeExecutionInput.executionId());
        ArrayList<CodeExecutionUtils.File> savedFiles = new ArrayList<CodeExecutionUtils.File>();
        if (codeExecutionResult.containsKey("output_files")) {
            List outputFiles = (List)codeExecutionResult.get("output_files");
            for (Map outputFile : outputFiles) {
                String fileName = (String)outputFile.get("name");
                String content = (String)outputFile.get("contents");
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1);
                Object mimeType = SUPPORTED_IMAGE_TYPES.contains((Object)fileType) ? "image/" + fileType : (SUPPORTED_DATA_FILE_TYPES.contains((Object)fileType) ? "text/" + fileType : URLConnection.guessContentTypeFromName(fileName));
                savedFiles.add(CodeExecutionUtils.File.builder().name(fileName).content(content).mimeType((String)mimeType).build());
            }
        }
        return CodeExecutionUtils.CodeExecutionResult.builder().stdout((String)codeExecutionResult.getOrDefault("execution_result", "")).stderr((String)codeExecutionResult.getOrDefault("execution_error", "")).outputFiles(savedFiles).build();
    }

    private Map<String, Object> executeCodeInterpreter(String code, List<CodeExecutionUtils.File> inputFiles, Optional<String> sessionId) {
        if (this.codeInterpreterExtension == null) {
            logger.warning("Vertex AI Code Interpreter execution is not available. Returning empty result.");
            return ImmutableMap.of((Object)"execution_result", (Object)"", (Object)"execution_error", (Object)"", (Object)"output_files", new ArrayList());
        }
        Struct.Builder paramsBuilder = Struct.newBuilder();
        paramsBuilder.putFields("query", Value.newBuilder().setStringValue(code).build());
        if (inputFiles != null && !inputFiles.isEmpty()) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (CodeExecutionUtils.File f : inputFiles) {
                Struct.Builder fileStructBuilder = Struct.newBuilder();
                fileStructBuilder.putFields("name", Value.newBuilder().setStringValue(f.name()).build());
                fileStructBuilder.putFields("contents", Value.newBuilder().setStringValue(f.content()).build());
                listBuilder.addValues(Value.newBuilder().setStructValue(fileStructBuilder.build()));
            }
            paramsBuilder.putFields("files", Value.newBuilder().setListValue(listBuilder.build()).build());
        }
        sessionId.ifPresent(s -> paramsBuilder.putFields("session_id", Value.newBuilder().setStringValue(s).build()));
        ExecuteExtensionRequest request = ExecuteExtensionRequest.newBuilder().setName(this.resourceName).setOperationId("generate_and_execute").setOperationParams(paramsBuilder.build()).build();
        ExecuteExtensionResponse response = this.codeInterpreterExtension.executeExtension(request);
        String jsonOutput = response.getContent();
        if (jsonOutput == null || jsonOutput.isEmpty()) {
            return ImmutableMap.of((Object)"execution_result", (Object)"", (Object)"execution_error", (Object)"", (Object)"output_files", new ArrayList());
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.readValue(jsonOutput, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to parse JSON from code interpreter: " + jsonOutput, e);
            return ImmutableMap.of((Object)"execution_result", (Object)"", (Object)"execution_error", (Object)("Failed to parse extension response: " + e.getMessage()), (Object)"output_files", new ArrayList());
        }
    }

    private String getCodeWithImports(String code) {
        return String.format("%s\n\n%s", IMPORTED_LIBRARIES, code);
    }
}

