/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.adk.JsonBaseModel;
import com.google.adk.codeexecutors.AutoValue_CodeExecutionUtils_CodeExecutionInput;
import com.google.adk.codeexecutors.AutoValue_CodeExecutionUtils_CodeExecutionResult;
import com.google.adk.codeexecutors.AutoValue_CodeExecutionUtils_File;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.genai.types.Content;
import com.google.genai.types.ExecutableCode;
import com.google.genai.types.Part;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CodeExecutionUtils {
    public static Part buildCodeExecutionResultPart(CodeExecutionResult result) {
        if (result.stderr() != null && !result.stderr().isEmpty()) {
            return Part.builder().codeExecutionResult(com.google.genai.types.CodeExecutionResult.builder().outcome("FAILED").output(result.stderr()).build()).build();
        }
        ArrayList<CallSite> finalResult = new ArrayList<CallSite>();
        if (result.stdout() != null && !result.stdout().isEmpty() || result.outputFiles() == null || result.outputFiles().isEmpty()) {
            finalResult.add((CallSite)((Object)("Code execution result:\n" + result.stdout() + "\n")));
        }
        if (result.outputFiles() != null && !result.outputFiles().isEmpty()) {
            String savedArtifacts = "Saved artifacts:\n" + result.outputFiles().stream().map(f -> "`" + f.name() + "`").collect(Collectors.joining(","));
            finalResult.add((CallSite)((Object)savedArtifacts));
        }
        return Part.builder().codeExecutionResult(com.google.genai.types.CodeExecutionResult.builder().outcome("OK").output(String.join((CharSequence)"\n\n", finalResult)).build()).build();
    }

    public static Part buildExecutableCodePart(String code) {
        return Part.builder().executableCode(ExecutableCode.builder().code(code).build()).build();
    }

    public static Content convertCodeExecutionParts(Content content, List<String> codeBlockDelimiters, List<String> executionResultDelimiters) {
        if (content.parts().isEmpty() || ((List)content.parts().get()).isEmpty()) {
            return content;
        }
        ImmutableList originalParts = ImmutableList.copyOf((Collection)((Collection)content.parts().get()));
        Part lastPart = (Part)Iterables.getLast((Iterable)originalParts);
        if (lastPart.executableCode().isPresent()) {
            ArrayList<Part> newParts = new ArrayList<Part>((Collection<Part>)originalParts);
            Part newPart = Part.fromText((String)(codeBlockDelimiters.get(0) + String.valueOf(((ExecutableCode)lastPart.executableCode().get()).code()) + codeBlockDelimiters.get(1)));
            newParts.set(newParts.size() - 1, newPart);
            return Content.builder().parts(newParts).role((String)content.role().get()).build();
        }
        if (originalParts.size() == 1 && lastPart.codeExecutionResult().isPresent()) {
            ArrayList<Part> newParts = new ArrayList<Part>((Collection<Part>)originalParts);
            Part newPart = Part.fromText((String)(executionResultDelimiters.get(0) + String.valueOf(((com.google.genai.types.CodeExecutionResult)lastPart.codeExecutionResult().get()).output()) + executionResultDelimiters.get(1)));
            newParts.set(newParts.size() - 1, newPart);
            return Content.builder().parts(newParts).role("user").build();
        }
        return content;
    }

    public static Optional<String> extractCodeAndTruncateContent(Content.Builder contentBuilder, List<List<String>> codeBlockDelimiters) {
        String trailingDelimiterPattern;
        Content content = contentBuilder.build();
        if (content.parts().isEmpty() || ((List)content.parts().get()).isEmpty()) {
            return Optional.empty();
        }
        List parts = (List)content.parts().get();
        for (int i = 0; i < parts.size(); ++i) {
            Part part = (Part)parts.get(i);
            if (!part.executableCode().isPresent() || i != parts.size() - 1 && !((Part)parts.get(i + 1)).codeExecutionResult().isEmpty()) continue;
            contentBuilder.parts((List)ImmutableList.copyOf(parts.subList(0, i + 1)));
            return part.executableCode().flatMap(ExecutableCode::code).filter(c -> !c.isEmpty());
        }
        ImmutableList textParts = (ImmutableList)parts.stream().filter(p -> p.text().isPresent() && !((String)p.text().get()).isEmpty()).collect(ImmutableList.toImmutableList());
        if (textParts.isEmpty()) {
            return Optional.empty();
        }
        String responseText = textParts.stream().map(p -> (String)p.text().get()).collect(Collectors.joining("\n"));
        String leadingDelimiterPattern = codeBlockDelimiters.stream().map(d -> Pattern.quote((String)d.get(0))).collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile("(?s)(?<prefix>.*?)(?:" + leadingDelimiterPattern + ")(?<code>.*?)(?:" + (trailingDelimiterPattern = codeBlockDelimiters.stream().map(d -> Pattern.quote((String)d.get(1))).collect(Collectors.joining("|"))) + ")(?<suffix>.*)");
        Matcher matcher = pattern.matcher(responseText);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String codeStr = matcher.group("code");
        if (Strings.isNullOrEmpty((String)codeStr)) {
            return Optional.empty();
        }
        ArrayList<Part> newParts = new ArrayList<Part>();
        String prefix = matcher.group("prefix");
        if (prefix != null && !prefix.isEmpty()) {
            newParts.add(((Part)textParts.get(0)).toBuilder().text(prefix).build());
        }
        newParts.add(CodeExecutionUtils.buildExecutableCodePart(codeStr));
        contentBuilder.parts(newParts);
        return Optional.of(codeStr);
    }

    private CodeExecutionUtils() {
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class CodeExecutionResult
    extends JsonBaseModel {
        public abstract String stdout();

        public abstract String stderr();

        public abstract ImmutableList<File> outputFiles();

        public static Builder builder() {
            return new AutoValue_CodeExecutionUtils_CodeExecutionResult.Builder().stdout("").stderr("").outputFiles((List<File>)ImmutableList.of());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder stdout(String var1);

            public abstract Builder stderr(String var1);

            public abstract Builder outputFiles(List<File> var1);

            public abstract CodeExecutionResult build();
        }
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class File
    extends JsonBaseModel {
        public abstract String name();

        public abstract String content();

        public abstract String mimeType();

        public static Builder builder() {
            return new AutoValue_CodeExecutionUtils_File.Builder().mimeType("text/plain");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder name(String var1);

            public abstract Builder content(String var1);

            public abstract Builder mimeType(String var1);

            public abstract File build();
        }
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class CodeExecutionInput
    extends JsonBaseModel {
        public abstract String code();

        public abstract ImmutableList<File> inputFiles();

        public abstract Optional<String> executionId();

        public static Builder builder() {
            return new AutoValue_CodeExecutionUtils_CodeExecutionInput.Builder().inputFiles((List<File>)ImmutableList.of()).executionId(Optional.empty());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder code(String var1);

            public abstract Builder inputFiles(List<File> var1);

            public abstract Builder executionId(Optional<String> var1);

            public abstract CodeExecutionInput build();
        }
    }
}

