/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.FunctionTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AgentTransfer
implements RequestProcessor {
    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        Method transferToAgentMethod;
        BaseAgent baseAgent = context.agent();
        if (!(baseAgent instanceof LlmAgent)) {
            throw new IllegalArgumentException("Base agent in InvocationContext is not an instance of Agent.");
        }
        LlmAgent agent = (LlmAgent)baseAgent;
        List<BaseAgent> transferTargets = this.getTransferTargets(agent);
        if (transferTargets.isEmpty()) {
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(request, (Iterable<Event>)ImmutableList.of()));
        }
        LlmRequest.Builder builder = request.toBuilder().appendInstructions((List<String>)ImmutableList.of((Object)this.buildTargetAgentsInstructions(agent, transferTargets)));
        try {
            transferToAgentMethod = AgentTransfer.class.getMethod("transferToAgent", String.class, ToolContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        FunctionTool agentTransferTool = FunctionTool.create(transferToAgentMethod);
        agentTransferTool.processLlmRequest(builder, ToolContext.builder(context).build());
        return Single.just((Object)RequestProcessor.RequestProcessingResult.create(builder.build(), (Iterable<Event>)ImmutableList.of()));
    }

    private String buildTargetAgentsInfo(BaseAgent targetAgent) {
        return String.format("Agent name: %s\nAgent description: %s", targetAgent.name(), targetAgent.description());
    }

    private String buildTargetAgentsInstructions(LlmAgent agent, List<BaseAgent> transferTargets) {
        StringBuilder sb = new StringBuilder();
        sb.append("You have a list of other agents to transfer to:\n");
        for (BaseAgent targetAgent : transferTargets) {
            sb.append(this.buildTargetAgentsInfo(targetAgent));
            sb.append("\n");
        }
        sb.append("If you are the best to answer the question according to your description, you can answer it.\n");
        sb.append("If another agent is better for answering the question according to its description, call `transferToAgent` function to transfer the question to that agent. When transferring, do not generate any text other than the function call.\n");
        if (agent.parentAgent() != null) {
            sb.append("Your parent agent is ");
            sb.append(agent.parentAgent().name());
            sb.append(".If neither the other agents nor you are best for answering the question according to the descriptions, transfer to your parent agent. If you don't have parent agent, try answer by yourself.\n");
        }
        return sb.toString();
    }

    private List<BaseAgent> getTransferTargets(LlmAgent agent) {
        ArrayList<BaseAgent> transferTargets = new ArrayList<BaseAgent>();
        transferTargets.addAll(agent.subAgents());
        BaseAgent parent = agent.parentAgent();
        if (!(parent instanceof LlmAgent)) {
            return transferTargets;
        }
        if (!agent.disallowTransferToParent()) {
            transferTargets.add(parent);
        }
        if (!agent.disallowTransferToPeers()) {
            for (BaseAgent baseAgent : parent.subAgents()) {
                if (baseAgent.name().equals(agent.name())) continue;
                transferTargets.add(baseAgent);
            }
        }
        return transferTargets;
    }

    public static void transferToAgent(String agentName, ToolContext toolContext) {
        EventActions eventActions = toolContext.eventActions();
        toolContext.setActions(eventActions.toBuilder().transferToAgent(agentName).build());
    }
}

