/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);
    public static final String JAVA_ADK_VERSION;

    private Version() {
    }

    static {
        String version = "unknown";
        try (InputStream input = Version.class.getClassLoader().getResourceAsStream("version.properties");){
            if (input != null) {
                Properties properties = new Properties();
                properties.load(input);
                version = properties.getProperty("version", "unknown");
            } else {
                logger.warn("version.properties file not found in classpath");
            }
        }
        catch (IOException e) {
            logger.warn("Failed to load version from properties file", (Throwable)e);
        }
        JAVA_ADK_VERSION = version;
    }
}

