/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.systemuicontroller;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.google.accompanist.systemuicontroller.SystemUiController;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016JA\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J9\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0006*\u00020\u0019H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Lcom/google/accompanist/systemuicontroller/AndroidSystemUiController;", "Lcom/google/accompanist/systemuicontroller/SystemUiController;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "window", "Landroid/view/Window;", "windowInsetsController", "Landroidx/core/view/WindowInsetsControllerCompat;", "isNavigationBarContrastEnforced", "", "setNavigationBarColor", "", "color", "Landroidx/compose/ui/graphics/Color;", "darkIcons", "navigationBarContrastEnforced", "transformColorForLightContent", "Lkotlin/Function1;", "setNavigationBarColor-Iv8Zu3U", "(JZZLkotlin/jvm/functions/Function1;)V", "setStatusBarColor", "setStatusBarColor-ek8zF_U", "(JZLkotlin/jvm/functions/Function1;)V", "findWindow", "Landroid/content/Context;", "systemuicontroller_release"})
public final class AndroidSystemUiController
implements SystemUiController {
    @Nullable
    private final Window window;
    @Nullable
    private final WindowInsetsControllerCompat windowInsetsController;

    public AndroidSystemUiController(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        this.window = this.findWindow(context);
        this.windowInsetsController = ViewCompat.getWindowInsetsController((View)view);
    }

    @Override
    public void setStatusBarColor-ek8zF_U(long color, boolean darkIcons, @NotNull Function1<? super Color, Color> transformColorForLightContent) {
        Intrinsics.checkNotNullParameter(transformColorForLightContent, (String)"transformColorForLightContent");
        WindowInsetsControllerCompat windowInsetsControllerCompat = this.windowInsetsController;
        if (windowInsetsControllerCompat != null) {
            windowInsetsControllerCompat.setAppearanceLightStatusBars(darkIcons);
        }
        windowInsetsControllerCompat = this.window;
        if (windowInsetsControllerCompat != null) {
            WindowInsetsControllerCompat windowInsetsControllerCompat2;
            windowInsetsControllerCompat.setStatusBarColor(ColorKt.toArgb-8_81llA((long)(darkIcons && !Intrinsics.areEqual((Object)((windowInsetsControllerCompat2 = this.windowInsetsController) == null ? null : Boolean.valueOf(windowInsetsControllerCompat2.isAppearanceLightStatusBars())), (Object)true) ? ((Color)transformColorForLightContent.invoke((Object)Color.box-impl((long)color))).unbox-impl() : color)));
        }
    }

    @Override
    public void setNavigationBarColor-Iv8Zu3U(long color, boolean darkIcons, boolean navigationBarContrastEnforced, @NotNull Function1<? super Color, Color> transformColorForLightContent) {
        Intrinsics.checkNotNullParameter(transformColorForLightContent, (String)"transformColorForLightContent");
        WindowInsetsControllerCompat windowInsetsControllerCompat = this.windowInsetsController;
        if (windowInsetsControllerCompat != null) {
            windowInsetsControllerCompat.setAppearanceLightNavigationBars(darkIcons);
        }
        windowInsetsControllerCompat = this.window;
        if (windowInsetsControllerCompat != null) {
            WindowInsetsControllerCompat windowInsetsControllerCompat2;
            windowInsetsControllerCompat.setNavigationBarColor(ColorKt.toArgb-8_81llA((long)(darkIcons && !Intrinsics.areEqual((Object)((windowInsetsControllerCompat2 = this.windowInsetsController) == null ? null : Boolean.valueOf(windowInsetsControllerCompat2.isAppearanceLightNavigationBars())), (Object)true) ? ((Color)transformColorForLightContent.invoke((Object)Color.box-impl((long)color))).unbox-impl() : color)));
        }
        if (Build.VERSION.SDK_INT >= 29 && (windowInsetsControllerCompat = this.window) != null) {
            windowInsetsControllerCompat.setNavigationBarContrastEnforced(navigationBarContrastEnforced);
        }
    }

    @Override
    public boolean isNavigationBarContrastEnforced() {
        Window window;
        return Build.VERSION.SDK_INT >= 29 && Intrinsics.areEqual((Object)((window = this.window) == null ? null : Boolean.valueOf(window.isNavigationBarContrastEnforced())), (Object)true);
    }

    private final Window findWindow(Context $this$findWindow) {
        Context context = $this$findWindow;
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return ((Activity)context).getWindow();
            }
            Context context2 = ((ContextWrapper)context).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.baseContext");
            context = context2;
        }
        return null;
    }

    @Override
    public void setSystemBarsColor-Iv8Zu3U(long color, boolean darkIcons, boolean isNavigationBarContrastEnforced, @NotNull Function1<? super Color, Color> transformColorForLightContent) {
        SystemUiController.DefaultImpls.setSystemBarsColor-Iv8Zu3U(this, color, darkIcons, isNavigationBarContrastEnforced, transformColorForLightContent);
    }
}

