/*
 * Decompiled with CFR 0.152.
 */
package androidx.lint.kotlin.metadata.jvm.internal;

import androidx.lint.kotlin.metadata.InconsistentKotlinMetadataException;
import androidx.lint.kotlin.metadata.KmClass;
import androidx.lint.kotlin.metadata.KmLambda;
import androidx.lint.kotlin.metadata.KmPackage;
import androidx.lint.kotlin.metadata.internal.ReadersKt;
import androidx.lint.kotlin.metadata.internal.metadata.ProtoBuf;
import androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmNameResolver;
import androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmProtoBufUtil;
import androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.ModuleMapping;
import androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.PackageParts;
import androidx.lint.kotlin.metadata.jvm.JvmMetadataVersion;
import androidx.lint.kotlin.metadata.jvm.KmModule;
import androidx.lint.kotlin.metadata.jvm.KmPackageParts;
import androidx.lint.kotlin.metadata.jvm.KotlinClassMetadata;
import androidx.lint.kotlin.metadata.jvm.UnstableMetadataApi;
import androidx.lint.kotlin.metadata.jvm.internal.JvmExceptionUtilsKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001d\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Landroidx/lint/kotlin/metadata/jvm/internal/JvmReadUtils;", "", "<init>", "()V", "isLessThan14", "", "annotationData", "Lkotlin/Metadata;", "readKmClass", "Landroidx/lint/kotlin/metadata/KmClass;", "readKmClass$kotlin_metadata_jvm", "readKmPackage", "Landroidx/lint/kotlin/metadata/KmPackage;", "readKmPackage$kotlin_metadata_jvm", "readKmLambda", "Landroidx/lint/kotlin/metadata/KmLambda;", "readKmLambda$kotlin_metadata_jvm", "readMetadataImpl", "Landroidx/lint/kotlin/metadata/jvm/KotlinClassMetadata;", "lenient", "readMetadataImpl$kotlin_metadata_jvm", "readModuleMetadataImpl", "Landroidx/lint/kotlin/metadata/jvm/KmModule;", "data", "Landroidx/lint/kotlin/metadata/internal/metadata/jvm/deserialization/ModuleMapping;", "readModuleMetadataImpl$kotlin_metadata_jvm", "checkMetadataVersionForRead", "", "throwIfNotCompatible", "jvmMetadataVersion", "Landroidx/lint/kotlin/metadata/internal/metadata/jvm/deserialization/JvmMetadataVersion;", "throwIfNotCompatible$kotlin_metadata_jvm", "kotlin-metadata-jvm"})
@SourceDebugExtension(value={"SMAP\nJvmReadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n15#3,8:101\n3193#4,10:109\n1279#4,2:119\n1293#4,4:121\n*S KotlinDebug\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n*L\n48#1:101,8\n64#1:109,10\n67#1:119,2\n67#1:121,4\n*E\n"})
public final class JvmReadUtils {
    @NotNull
    public static final JvmReadUtils INSTANCE = new JvmReadUtils();

    private JvmReadUtils() {
    }

    private final boolean isLessThan14(Metadata annotationData) {
        return new JvmMetadataVersion(annotationData.mv()).compareTo(new JvmMetadataVersion(1, 4, 0)) < 0;
    }

    @NotNull
    public final KmClass readKmClass$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = pair.component1();
        ProtoBuf.Class proto = pair.component2();
        return ReadersKt.toKmClass$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @NotNull
    public final KmPackage readKmPackage$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = pair.component1();
        ProtoBuf.Package proto = pair.component2();
        return ReadersKt.toKmPackage$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @Nullable
    public final KmLambda readKmLambda$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(annotationData, "annotationData");
                String[] stringArray = annotationData.d1();
                Object[] p0 = stringArray;
                boolean bl = false;
                object = !(p0.length == 0) ? stringArray : null;
                if (object == null) break block2;
                String[] data1 = object;
                boolean bl2 = false;
                Pair<JvmNameResolver, ProtoBuf.Function> pair = JvmProtoBufUtil.readFunctionDataFrom(data1, annotationData.d2());
                object = pair;
                if (pair != null) break block3;
            }
            return null;
        }
        Object functionData = object;
        JvmNameResolver strings = (JvmNameResolver)((Pair)functionData).component1();
        ProtoBuf.Function proto = (ProtoBuf.Function)((Pair)functionData).component2();
        return ReadersKt.toKmLambda(proto, strings, this.isLessThan14(annotationData));
    }

    @NotNull
    public final KotlinClassMetadata readMetadataImpl$kotlin_metadata_jvm(@NotNull Metadata annotationData, boolean lenient) {
        KotlinClassMetadata kotlinClassMetadata;
        Intrinsics.checkNotNullParameter(annotationData, "annotationData");
        this.checkMetadataVersionForRead(annotationData, lenient);
        boolean $i$f$wrapIntoMetadataExceptionWhenNeeded = false;
        try {
            KotlinClassMetadata kotlinClassMetadata2;
            boolean bl = false;
            switch (annotationData.k()) {
                case 1: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Class(annotationData, lenient);
                    break;
                }
                case 2: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.FileFacade(annotationData, lenient);
                    break;
                }
                case 3: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.SyntheticClass(annotationData, lenient);
                    break;
                }
                case 4: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassFacade(annotationData, lenient);
                    break;
                }
                case 5: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassPart(annotationData, lenient);
                    break;
                }
                default: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Unknown(annotationData, lenient);
                }
            }
            kotlinClassMetadata = kotlinClassMetadata2;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new InconsistentKotlinMetadataException("Exception occurred when reading Kotlin metadata", e$iv));
        }
        return kotlinClassMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @UnstableMetadataApi
    @NotNull
    public final KmModule readModuleMetadataImpl$kotlin_metadata_jvm(@NotNull ModuleMapping data) {
        Intrinsics.checkNotNullParameter(data, "data");
        KmModule v = new KmModule();
        for (Map.Entry<String, PackageParts> entry : data.getPackageFqName2Parts().entrySet()) {
            void $this$associateWith$iv;
            String fqName = entry.getKey();
            PackageParts parts = entry.getValue();
            Iterable $this$partition$iv = parts.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (parts.getMultifileFacadeName(it) == null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List fileFacades = pair.component1();
            List multiFileClassParts = pair.component2();
            Map<String, KmPackageParts> map = v.getPackageParts();
            second$iv = multiFileClassParts;
            List<String> list = CollectionsKt.toMutableList(fileFacades);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(parts.getMultifileFacadeName((String)it));
                map2.put(t, string);
            }
            Map<String, String> map3 = MapsKt.toMutableMap(result$iv);
            List<String> list2 = list;
            KmPackageParts kmPackageParts = new KmPackageParts(list2, map3);
            map.put(fqName, kmPackageParts);
        }
        for (ProtoBuf.Class classProto : data.getModuleData().getOptionalAnnotations()) {
            v.getOptionalAnnotationClasses().add(ReadersKt.toKmClass$default(classProto, data.getModuleData().getNameResolver(), false, null, 4, null));
        }
        return v;
    }

    private final void checkMetadataVersionForRead(Metadata annotationData, boolean lenient) {
        if (annotationData.mv().length == 0) {
            throw new IllegalArgumentException("Provided Metadata instance does not have metadataVersion in it and therefore is malformed and cannot be read.");
        }
        androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion jvmMetadataVersion = new androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion(annotationData.mv(), (annotationData.xi() & 8) != 0);
        this.throwIfNotCompatible$kotlin_metadata_jvm(jvmMetadataVersion, lenient);
    }

    public final void throwIfNotCompatible$kotlin_metadata_jvm(@NotNull androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion jvmMetadataVersion, boolean lenient) {
        boolean isCompatible;
        Intrinsics.checkNotNullParameter(jvmMetadataVersion, "jvmMetadataVersion");
        boolean isAtLeast110 = jvmMetadataVersion.isAtLeast(1, 1, 0);
        boolean bl = isCompatible = lenient ? isAtLeast110 : jvmMetadataVersion.isCompatibleWithCurrentCompilerVersion();
        if (!isCompatible) {
            String postfix = !isAtLeast110 ? "while minimum supported version is 1.1.0 (Kotlin 1.0)." : "while maximum supported version is " + (jvmMetadataVersion.isStrictSemantics() ? androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion.INSTANCE : androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion.INSTANCE_NEXT) + ". To support newer versions, update the kotlin-metadata-jvm library.";
            throw new IllegalArgumentException("Provided Metadata instance has version " + jvmMetadataVersion + ", " + postfix);
        }
    }
}

