/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.undo;

import com.goodow.realtime.operation.undo.UndoManagerImpl;
import com.goodow.realtime.operation.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class UndoStack<T> {
    private static int MAX_CAPACITY = 100;
    private final UndoManagerImpl.Algorithms<T> algorithms;
    private final List<T> ops = new LinkedList<T>();
    private boolean checkpointer;

    UndoStack(UndoManagerImpl.Algorithms<T> algorithms) {
        this.algorithms = algorithms;
    }

    void checkpoint() {
        this.checkpointer = true;
    }

    void clear() {
        this.ops.clear();
    }

    boolean isEmpty() {
        return this.ops.isEmpty();
    }

    void nonUndoableOperation(T op) {
        assert (op != null);
        if (!this.ops.isEmpty()) {
            this.ops.add(op);
            this.keepCapacity(this.ops);
        }
    }

    Pair<List<T>, List<T>> pop() {
        int index;
        ArrayList transformedClientOps = new ArrayList();
        while (this.ops.get((index = this.popOne(transformedClientOps)) - 1) != null) {
        }
        this.ops.remove(index - 1);
        return Pair.of(transformedClientOps, this.ops.subList(index - 1, this.ops.size()));
    }

    void push(T op) {
        assert (op != null);
        if (this.ops.isEmpty() && !this.checkpointer) {
            return;
        }
        if (this.checkpointer) {
            this.ops.add(null);
            this.checkpointer = false;
        }
        this.ops.add(null);
        this.ops.add(op);
        this.keepCapacity(this.ops);
    }

    private void keepCapacity(List<T> list) {
        int size = list.size();
        if (size <= MAX_CAPACITY) {
            return;
        }
        assert (list.get(0) == null && list.get(1) == null);
        list.remove(1);
        list.remove(0);
        size -= 2;
        int nextCheckpointer = -1;
        boolean previousIsNull = false;
        for (T op : list) {
            if (previousIsNull && op == null && size - nextCheckpointer <= MAX_CAPACITY) break;
            ++nextCheckpointer;
            previousIsNull = op == null;
        }
        for (int i = 0; i < nextCheckpointer; ++i) {
            list.remove(0);
        }
    }

    private int popOne(List<T> results) {
        int index = this.ops.lastIndexOf(null);
        this.ops.remove(index);
        T op = this.algorithms.invert(this.ops.remove(index));
        if (op != null) {
            this.algorithms.transform(results, op, this.ops, index);
        }
        return index;
    }
}

