/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.undo;

import com.goodow.realtime.operation.undo.UndoManagerPlus;
import com.goodow.realtime.operation.undo.UndoStack;
import com.goodow.realtime.operation.util.Pair;
import java.util.List;

public final class UndoManagerImpl<T>
implements UndoManagerPlus<T> {
    private final UndoStack<T> undoStack;
    private final UndoStack<T> redoStack;

    public UndoManagerImpl(Algorithms<T> algorithms) {
        this.undoStack = new UndoStack<T>(algorithms);
        this.redoStack = new UndoStack<T>(algorithms);
    }

    @Override
    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    @Override
    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    @Override
    public void checkpoint() {
        this.undoStack.checkpoint();
    }

    @Override
    public void nonUndoableOp(T op) {
        this.undoStack.nonUndoableOperation(op);
        this.redoStack.nonUndoableOperation(op);
    }

    @Override
    public List<T> redo() {
        Pair<List<T>, List<T>> redoPlus = this.redoPlus();
        return (List)redoPlus.first;
    }

    @Override
    public Pair<List<T>, List<T>> redoPlus() {
        if (!this.canRedo()) {
            throw new UnsupportedOperationException("Redo stack is empty.");
        }
        Pair<List<T>, List<T>> pair = this.redoStack.pop();
        this.undoStack.checkpoint();
        for (Object op : (List)pair.first) {
            this.undoStack.push(op);
        }
        return pair;
    }

    @Override
    public List<T> undo() {
        Pair<List<T>, List<T>> undoPlus = this.undoPlus();
        return (List)undoPlus.first;
    }

    @Override
    public void undoableOp(T op) {
        this.undoStack.push(op);
        this.redoStack.clear();
    }

    @Override
    public Pair<List<T>, List<T>> undoPlus() {
        if (!this.canUndo()) {
            throw new UnsupportedOperationException("Undo stack is empty.");
        }
        Pair<List<T>, List<T>> pair = this.undoStack.pop();
        this.redoStack.checkpoint();
        for (Object op : (List)pair.first) {
            this.redoStack.push(op);
        }
        return pair;
    }

    public static interface Algorithms<T> {
        public T invert(T var1);

        public void transform(List<T> var1, T var2, List<T> var3, int var4);
    }
}

