/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.undo;

import com.goodow.realtime.operation.RealtimeOperation;
import com.goodow.realtime.operation.Transformer;
import com.goodow.realtime.operation.TransformerImpl;
import com.goodow.realtime.operation.undo.UndoManagerImpl;
import com.goodow.realtime.operation.undo.UndoManagerPlus;
import com.goodow.realtime.operation.util.Pair;
import java.util.List;

public final class UndoManagerFactory {
    private static final UndoManagerPlus<?> NOP_IMPL = new UndoManagerPlus<Object>(){

        @Override
        public boolean canRedo() {
            return false;
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void checkpoint() {
        }

        @Override
        public void nonUndoableOp(Object op) {
        }

        @Override
        public List<Object> redo() {
            return (List)this.redoPlus().first;
        }

        @Override
        public Pair<List<Object>, List<Object>> redoPlus() {
            throw new UnsupportedOperationException("No Redo For You!");
        }

        @Override
        public List<Object> undo() {
            return (List)this.undoPlus().first;
        }

        @Override
        public void undoableOp(Object op) {
        }

        @Override
        public Pair<List<Object>, List<Object>> undoPlus() {
            throw new UnsupportedOperationException("No Undo For You!");
        }
    };
    private static final UndoManagerImpl.Algorithms<RealtimeOperation> algorithms = new UndoManagerImpl.Algorithms<RealtimeOperation>(){
        Transformer<RealtimeOperation> transformer = new TransformerImpl<RealtimeOperation>();

        @Override
        public RealtimeOperation invert(RealtimeOperation operation) {
            return operation.invert();
        }

        @Override
        public void transform(List<RealtimeOperation> results, RealtimeOperation clientOp, List<RealtimeOperation> serverOps, int startIndex) {
            this.transformer.transform(results, clientOp, serverOps, startIndex, true);
        }
    };

    public static UndoManagerPlus<RealtimeOperation> createUndoManager() {
        return new UndoManagerImpl<RealtimeOperation>(algorithms);
    }

    public static <T> UndoManagerPlus<T> getNoOp() {
        return NOP_IMPL;
    }
}

