/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.number;

import com.goodow.realtime.operation.AbstractOperation;
import com.goodow.realtime.operation.number.NumberAddOperation;
import com.goodow.realtime.operation.number.NumberTarget;

public class NumberResetOperation
extends AbstractOperation<NumberTarget> {
    public static final int TYPE = 9;
    private final double oldNumber;
    private final double newNumber;

    public NumberResetOperation(String id, double oldNumber, double newNumber) {
        super(9, id);
        assert (!Double.isNaN(newNumber) && oldNumber != newNumber);
        this.oldNumber = oldNumber;
        this.newNumber = newNumber;
    }

    @Override
    public void apply(NumberTarget target) {
        target.reset(this.newNumber);
    }

    @Override
    public NumberResetOperation invert() {
        assert (!Double.isNaN(this.oldNumber));
        return new NumberResetOperation(this.id, this.newNumber, this.oldNumber);
    }

    public NumberResetOperation[] transformWith(AbstractOperation<NumberTarget> operation, boolean arrivedAfter) {
        assert ((operation instanceof NumberResetOperation || operation instanceof NumberAddOperation) && this.isSameId(operation));
        if (arrivedAfter && operation instanceof NumberResetOperation) {
            double transformedOldNumber = ((NumberResetOperation)operation).newNumber;
            return transformedOldNumber == this.newNumber ? null : this.asArray(new NumberResetOperation(this.id, transformedOldNumber, this.newNumber));
        }
        return null;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(this.newNumber);
    }
}

