/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.number;

import com.goodow.realtime.operation.AbstractOperation;
import com.goodow.realtime.operation.number.NumberResetOperation;
import com.goodow.realtime.operation.number.NumberTarget;

public class NumberAddOperation
extends AbstractOperation<NumberTarget> {
    public static final int TYPE = 8;
    private final double number;

    public NumberAddOperation(String id, double number) {
        super(8, id);
        assert (number != 0.0);
        this.number = number;
    }

    @Override
    public void apply(NumberTarget target) {
        target.add(this.number);
    }

    @Override
    public NumberAddOperation invert() {
        return new NumberAddOperation(this.id, -this.number);
    }

    public NumberAddOperation[] transformWith(AbstractOperation<NumberTarget> operation, boolean arrivedAfter) {
        assert ((operation instanceof NumberAddOperation || operation instanceof NumberResetOperation) && this.isSameId(operation));
        return operation instanceof NumberAddOperation ? this.asArray(this) : null;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(this.number);
    }
}

