/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.map.json;

import com.goodow.realtime.operation.map.AbstractMapOperation;
import elemental.json.JsonArray;
import elemental.json.JsonType;
import elemental.json.JsonValue;

public class JsonMapOperation
extends AbstractMapOperation<JsonValue> {
    public static boolean jsonEquals(JsonValue value0, JsonValue value1) {
        return value0 == null ? value1 == null : (value1 == null ? false : value0.toJson().equals(value1.toJson()));
    }

    public static JsonMapOperation parse(JsonArray serialized) {
        int length = serialized.length();
        assert (serialized.getNumber(0) == 8.0 && (length == 3 || length == 4));
        return new JsonMapOperation(JsonMapOperation.parseId(serialized), serialized.getString(2), null, length == 3 ? null : serialized.get(3));
    }

    public JsonMapOperation(String id, String key, JsonValue oldValue, JsonValue newValue) {
        super(id, key, oldValue, newValue);
        assert (oldValue == null || oldValue.getType() != JsonType.NULL);
        assert (newValue == null || newValue.getType() != JsonType.NULL);
    }

    @Override
    public JsonMapOperation invert() {
        return new JsonMapOperation(this.id, this.key, (JsonValue)this.newValue, (JsonValue)this.oldValue);
    }

    protected JsonMapOperation create(String id, String key, JsonValue oldValue, JsonValue newValue) {
        return new JsonMapOperation(id, key, oldValue, newValue);
    }

    @Override
    protected boolean equals(JsonValue value0, JsonValue value1) {
        return JsonMapOperation.jsonEquals(value0, value1);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        if (this.newValue != null) {
            sb.append(',').append(((JsonValue)this.newValue).toJson());
        }
    }
}

