/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.map;

import com.goodow.realtime.operation.AbstractOperation;
import com.goodow.realtime.operation.map.MapTarget;

public abstract class AbstractMapOperation<T>
extends AbstractOperation<MapTarget<T>> {
    public static final int TYPE = 8;
    protected final String key;
    protected final T oldValue;
    protected final T newValue;

    protected AbstractMapOperation(String id, String key, T oldValue, T newValue) {
        super(8, id);
        assert (key != null) : "Null key";
        assert (oldValue == null && newValue == null || !this.equals(oldValue, newValue));
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void apply(MapTarget<T> target) {
        target.set(this.key, this.newValue);
    }

    public AbstractMapOperation<T>[] transformWith(AbstractOperation<MapTarget<T>> operation, boolean arrivedAfter) {
        assert (operation instanceof AbstractMapOperation && this.isSameId(operation));
        AbstractMapOperation op = (AbstractMapOperation)operation;
        if (!this.key.equals(op.key)) {
            return this.asArray(this);
        }
        if (!arrivedAfter || this.equals(this.newValue, op.newValue)) {
            return null;
        }
        return this.asArray(this.create(this.id, this.key, op.newValue, this.newValue));
    }

    protected abstract AbstractMapOperation<T> create(String var1, String var2, T var3, T var4);

    protected boolean equals(T value0, T value1) {
        return value0 == null ? value1 == null : value0.equals(value1);
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append('\"').append(this.key).append('\"');
    }
}

