/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.list.string;

import com.goodow.realtime.operation.list.ListHelper;
import elemental.json.JsonArray;

public class StringHelper
implements ListHelper<String> {
    public static final int TYPE = 1;
    static final StringHelper INSTANCE = new StringHelper();

    @Override
    public int length(String values) {
        return values.length();
    }

    @Override
    public String parseValues(JsonArray serialized) {
        assert (serialized.getNumber(0) == 1.0 && serialized.length() == 2);
        String string = serialized.getString(1);
        assert (!string.isEmpty());
        return string;
    }

    @Override
    public String replaceWith(String values, int startIndex, int length, String replacement) {
        return values.substring(0, startIndex) + (replacement == null ? "" : replacement) + values.substring(startIndex + length);
    }

    @Override
    public StringBuilder serialize(String values) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(1).append(",\"").append(values).append('\"');
        sb.append(']');
        return sb;
    }

    @Override
    public String subset(String values, int startIndex, int length) {
        return values.substring(startIndex, startIndex + length);
    }

    @Override
    public String subset(String values, int startIndex0, int length0, int startIndex1, int length1) {
        return this.subset(values, startIndex0, length0, values, startIndex1, length1);
    }

    @Override
    public String subset(String values0, int startIndex0, int length0, String values1, int startIndex1, int length1) {
        return this.subset(values0, startIndex0, length0) + this.subset(values1, startIndex1, length1);
    }
}

