/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.list.json;

import com.goodow.realtime.operation.list.ListHelper;
import elemental.json.JsonArray;
import elemental.json.JsonValue;

public class JsonHelper
implements ListHelper<JsonValue[]> {
    public static final int TYPE = 0;
    static final JsonHelper INSTANCE = new JsonHelper();

    @Override
    public int length(JsonValue[] values) {
        return values.length;
    }

    @Override
    public JsonValue[] parseValues(JsonArray serialized) {
        assert (serialized.getNumber(0) == 0.0);
        int length = serialized.length();
        assert (length >= 2);
        JsonValue[] values = this.create(length - 1);
        for (int i = 1; i < length; ++i) {
            values[i - 1] = serialized.get(i);
        }
        return values;
    }

    @Override
    public JsonValue[] replaceWith(JsonValue[] values, int startIndex, int length, JsonValue[] replacement) {
        int len = replacement == null ? 0 : replacement.length;
        JsonValue[] array = this.create(values.length - length + len);
        System.arraycopy(values, 0, array, 0, startIndex);
        if (replacement != null) {
            System.arraycopy(replacement, 0, array, startIndex, len);
        }
        System.arraycopy(values, startIndex + length, array, startIndex + len, values.length - startIndex - length);
        return array;
    }

    @Override
    public StringBuilder serialize(JsonValue[] values) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(0);
        for (JsonValue value : values) {
            sb.append(',').append(value == null ? (String)null : value.toJson());
        }
        sb.append(']');
        return sb;
    }

    @Override
    public JsonValue[] subset(JsonValue[] values, int startIndex, int length) {
        JsonValue[] array = this.create(length);
        System.arraycopy(values, startIndex, array, 0, length);
        return array;
    }

    @Override
    public JsonValue[] subset(JsonValue[] values, int startIndex0, int length0, int startIndex1, int length1) {
        return this.subset(values, startIndex0, length0, values, startIndex1, length1);
    }

    @Override
    public JsonValue[] subset(JsonValue[] values0, int startIndex0, int length0, JsonValue[] values1, int startIndex1, int length1) {
        JsonValue[] array = this.create(length0 + length1);
        System.arraycopy(values0, startIndex0, array, 0, length0);
        System.arraycopy(values1, startIndex1, array, length0, length1);
        return array;
    }

    protected JsonValue[] create(int length) {
        return new JsonValue[length];
    }
}

