/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation.cursor;

import com.goodow.realtime.operation.AbstractOperation;
import elemental.json.JsonArray;

public class ReferenceShiftedOperation
extends AbstractOperation<Void> {
    public static final int TYPE = 25;
    public final String referencedObjectId;
    public final int newIndex;
    public final boolean canBeDeleted;
    public final int oldIndex;

    public static ReferenceShiftedOperation parse(JsonArray serialized) {
        assert (serialized.getNumber(0) == 25.0 && serialized.length() == 6);
        return new ReferenceShiftedOperation(ReferenceShiftedOperation.parseId(serialized), serialized.getString(2), (int)serialized.getNumber(3), serialized.getBoolean(4), (int)serialized.getNumber(5));
    }

    public ReferenceShiftedOperation(String id, String referencedObjectId, int newIndex, boolean canBeDeleted, int oldIndex) {
        super(25, id);
        this.referencedObjectId = referencedObjectId;
        this.newIndex = newIndex;
        this.canBeDeleted = canBeDeleted;
        this.oldIndex = oldIndex;
    }

    @Override
    public void apply(Void target) {
        throw new IllegalStateException();
    }

    @Override
    public ReferenceShiftedOperation invert() {
        return new ReferenceShiftedOperation(this.id, this.referencedObjectId, this.oldIndex, this.canBeDeleted, this.newIndex);
    }

    public ReferenceShiftedOperation[] transformWith(AbstractOperation<Void> operation, boolean arrivedAfter) {
        assert (operation instanceof ReferenceShiftedOperation && this.isSameId(operation));
        ReferenceShiftedOperation op = (ReferenceShiftedOperation)operation;
        assert (this.referencedObjectId.equals(op.referencedObjectId));
        return arrivedAfter ? this.asArray(new ReferenceShiftedOperation(this.id, this.referencedObjectId, this.newIndex, this.canBeDeleted, op.newIndex)) : null;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append('\"').append(this.referencedObjectId).append("\",").append(this.newIndex).append(',');
        sb.append(this.canBeDeleted).append(',').append(this.oldIndex);
    }
}

