/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation;

import com.goodow.realtime.operation.AbstractOperation;
import com.goodow.realtime.operation.Operation;
import com.goodow.realtime.operation.RealtimeOperation;
import com.goodow.realtime.operation.Transformer;
import com.goodow.realtime.operation.create.CreateOperation;
import com.goodow.realtime.operation.cursor.ReferenceShiftedOperation;
import com.goodow.realtime.operation.list.SimpleDeleteOperation;
import com.goodow.realtime.operation.list.json.JsonInsertOperation;
import com.goodow.realtime.operation.list.json.JsonReplaceOperation;
import com.goodow.realtime.operation.list.string.StringInsertOperation;
import com.goodow.realtime.operation.map.json.JsonMapOperation;
import com.goodow.realtime.operation.util.Pair;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TransformerImpl<T extends Operation<?>>
implements Transformer<T> {
    @Override
    public List<T> compact(List<T> operations) {
        return operations;
    }

    public AbstractOperation<?> createOperation(JsonArray serialized) {
        AbstractOperation op = null;
        block0 : switch ((int)serialized.getNumber(0)) {
            case 7: {
                op = CreateOperation.parse(serialized);
                break;
            }
            case 8: {
                op = JsonMapOperation.parse(serialized);
                break;
            }
            case 5: {
                switch ((int)serialized.getArray(3).getNumber(0)) {
                    case 0: {
                        op = JsonInsertOperation.parse(serialized);
                        break block0;
                    }
                    case 1: {
                        op = StringInsertOperation.parse(serialized);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unknow insert operation sub-type: " + serialized.toJson());
            }
            case 6: {
                op = SimpleDeleteOperation.parse(serialized);
                break;
            }
            case 11: {
                op = JsonReplaceOperation.parse(serialized);
                break;
            }
            case 25: {
                op = ReferenceShiftedOperation.parse(serialized);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknow operation type: " + serialized.toJson());
            }
        }
        return op;
    }

    @Override
    public T createOperation(String userId, String sessionId, JsonValue serialized) {
        JsonArray ops = (JsonArray)serialized;
        int length = ops.length();
        assert (length > 0);
        ArrayList operations = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            operations.add(this.createOperation(ops.getArray(i)));
        }
        return (T)new RealtimeOperation(userId, sessionId, operations);
    }

    @Override
    public Pair<List<T>, List<T>> transform(List<T> clientOps, List<T> serverOps) {
        assert (!clientOps.contains(null) && !serverOps.contains(null));
        ArrayList transformedClientOps = new ArrayList();
        LinkedList<T> transformedServerOps = new LinkedList<T>(serverOps);
        for (Operation clientOp : clientOps) {
            this.transform(transformedClientOps, clientOp, transformedServerOps, 0, true);
        }
        return Pair.of(transformedClientOps, transformedServerOps);
    }

    @Override
    public void transform(List<T> transformedResults, T operation, List<T> operations, int startIndex, boolean arrivedAfter) {
        Operation[] transformedOps0;
        assert (operation != null);
        if (startIndex == operations.size()) {
            transformedResults.add(operation);
            return;
        }
        Operation op1 = (Operation)operations.get(startIndex);
        assert (op1 != null);
        if (operation instanceof AbstractOperation && !((AbstractOperation)operation).isSameId((AbstractOperation)op1)) {
            this.transform(transformedResults, operation, operations, ++startIndex, arrivedAfter);
            return;
        }
        Pair<Operation<T>[], Operation<T>[]> pair = arrivedAfter ? operation.transformWith(op1) : op1.transformWith(operation);
        Operation[] transformedOps1 = arrivedAfter ? (Operation[])pair.second : (Operation[])pair.first;
        operations.remove(startIndex);
        if (transformedOps1 != null) {
            for (Operation op : transformedOps1) {
                operations.add(startIndex++, op);
            }
        }
        Operation[] operationArray = transformedOps0 = arrivedAfter ? (Operation[])pair.first : (Operation[])pair.second;
        if (transformedOps0 == null) {
            return;
        }
        for (Operation op : transformedOps0) {
            this.transform(transformedResults, op, operations, startIndex, arrivedAfter);
        }
    }
}

