/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation;

import com.goodow.realtime.operation.Operation;
import com.goodow.realtime.operation.TransformerImpl;
import com.goodow.realtime.operation.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RealtimeOperation
implements Operation<Object> {
    public final String userId;
    public final String sessionId;
    public final List<? extends Operation<?>> operations;

    public RealtimeOperation(String userId, String sessionId, List<? extends Operation<?>> operations) {
        assert (operations != null && !operations.isEmpty() && !operations.contains(null));
        this.userId = userId;
        this.sessionId = sessionId;
        this.operations = Collections.unmodifiableList(operations);
    }

    public RealtimeOperation(String userId, String sessionId, Operation<?> ... operations) {
        this(userId, sessionId, Arrays.asList(operations));
    }

    @Override
    public void apply(Object target) {
        for (Operation<?> op : this.operations) {
            op.apply(target);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeOperation)) {
            return false;
        }
        RealtimeOperation other = (RealtimeOperation)obj;
        if (this.operations == null ? other.operations != null : !this.operations.equals(other.operations)) {
            return false;
        }
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public RealtimeOperation invert() {
        int size = this.operations.size();
        ArrayList ops = new ArrayList(size);
        for (int i = size - 1; i >= 0; --i) {
            Operation<?> invertOp = this.operations.get(i).invert();
            if (invertOp == null) continue;
            ops.add(invertOp);
        }
        return ops.isEmpty() ? null : new RealtimeOperation(this.userId, this.sessionId, ops);
    }

    @Override
    public String toString() {
        return this.operations.toString();
    }

    @Override
    public Pair<RealtimeOperation[], RealtimeOperation[]> transformWith(Operation<Object> serverOperation) {
        RealtimeOperation[] realtimeOperationArray;
        RealtimeOperation[] realtimeOperationArray2;
        assert (serverOperation instanceof RealtimeOperation);
        RealtimeOperation serverOp = (RealtimeOperation)serverOperation;
        TransformerImpl transformer = new TransformerImpl();
        Pair<List<? extends Operation<?>>, List<? extends Operation<?>>> pair = transformer.transform(this.operations, serverOp.operations);
        if (((List)pair.first).isEmpty()) {
            realtimeOperationArray2 = null;
        } else {
            RealtimeOperation[] realtimeOperationArray3 = new RealtimeOperation[1];
            realtimeOperationArray2 = realtimeOperationArray3;
            realtimeOperationArray3[0] = new RealtimeOperation(this.userId, this.sessionId, (List)pair.first);
        }
        RealtimeOperation[] transformedClientOp = realtimeOperationArray2;
        if (((List)pair.second).isEmpty()) {
            realtimeOperationArray = null;
        } else {
            RealtimeOperation[] realtimeOperationArray4 = new RealtimeOperation[1];
            realtimeOperationArray = realtimeOperationArray4;
            realtimeOperationArray4[0] = new RealtimeOperation(serverOp.userId, serverOp.sessionId, (List)pair.second);
        }
        RealtimeOperation[] transformedServerOp = realtimeOperationArray;
        return Pair.of(transformedClientOp, transformedServerOp);
    }
}

