/*
 * Decompiled with CFR 0.152.
 */
package com.goodow.realtime.operation;

import com.goodow.realtime.operation.Operation;
import com.goodow.realtime.operation.util.Pair;
import elemental.json.JsonArray;
import elemental.json.JsonType;

public abstract class AbstractOperation<T>
implements Operation<T> {
    public final int type;
    public final String id;

    protected static String parseId(JsonArray serialized) {
        return serialized.get(1).getType() == JsonType.NULL ? null : serialized.getString(1);
    }

    protected AbstractOperation(int type, String id) {
        this.type = type;
        this.id = id;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    @Override
    public abstract AbstractOperation<T> invert();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append('[');
        sb.append(this.type).append(',');
        if (this.id == null) {
            sb.append((String)null);
        } else {
            sb.append('\"').append(this.id).append('\"');
        }
        sb.append(',');
        this.toString(sb);
        sb.append(']');
        return sb.toString();
    }

    public abstract AbstractOperation<T>[] transformWith(AbstractOperation<T> var1, boolean var2);

    @Override
    public Pair<AbstractOperation<T>[], AbstractOperation<T>[]> transformWith(Operation<T> serverOperation) {
        assert (serverOperation instanceof AbstractOperation && this.isSameId((AbstractOperation)serverOperation));
        AbstractOperation serverOp = (AbstractOperation)serverOperation;
        AbstractOperation<T>[] transformedClientOps = this.transformWith(serverOp, true);
        AbstractOperation<T>[] transformedServerOps = serverOp.transformWith(this, false);
        return Pair.of(transformedClientOps, transformedServerOps);
    }

    @SafeVarargs
    protected final <O> O[] asArray(O ... operations) {
        return operations;
    }

    protected boolean isSameId(AbstractOperation<?> operation) {
        String id2 = operation.id;
        return this.id == null ? id2 == null : this.id.equals(id2);
    }

    protected abstract void toString(StringBuilder var1);
}

