/*
 * Decompiled with CFR 0.152.
 */
package com.globo.dnsapi;

import com.globo.dnsapi.DNSAPI;
import com.globo.dnsapi.DNSAPIException;
import com.globo.dnsapi.model.DNSAPIRoot;
import com.globo.dnsapi.model.ErrorMessage;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAPI<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractAPI.class);
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    static final JsonObjectParser parser = new JsonObjectParser(JSON_FACTORY);
    private final DNSAPI dnsapi;
    private HttpRequestFactory requestFactory;

    protected AbstractAPI(DNSAPI dnsapi) {
        if (dnsapi == null) {
            throw new IllegalArgumentException("No DNSAPI configured");
        }
        this.dnsapi = dnsapi;
        this.requestFactory = this.buildHttpRequestFactory();
    }

    protected DNSAPI getDnsapi() {
        return this.dnsapi;
    }

    protected abstract Type getType();

    protected abstract Type getListType();

    protected HttpRequestFactory buildHttpRequestFactory() {
        HttpRequestFactory request = this.getDnsapi().getHttpTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setNumberOfRetries(1);
                request.setThrowExceptionOnExecuteError(false);
                request.setParser((ObjectParser)parser);
                request.setLoggingEnabled(true);
                request.getHeaders().setUserAgent("DNSAPI-Java-Client");
                request.setCurlLoggingEnabled(true);
                request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

                    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                        if (response.getStatusCode() == 401) {
                            AbstractAPI.this.getDnsapi().clearToken();
                            if (supportsRetry) {
                                AbstractAPI.this.insertAuthenticationHeaders(request);
                                return true;
                            }
                        }
                        return false;
                    }
                });
                request.setResponseInterceptor(new HttpResponseInterceptor(){

                    public void interceptResponse(HttpResponse response) throws IOException {
                        LOGGER.debug("Response from {} {} is {} {}", new Object[]{response.getRequest().getRequestMethod(), response.getRequest().getUrl(), response.getStatusCode(), response.getStatusMessage()});
                        AbstractAPI.this.interceptResponse(response);
                    }
                });
                AbstractAPI.this.interceptRequest(request);
            }
        });
        return request;
    }

    protected void interceptRequest(HttpRequest request) {
        this.insertAuthenticationHeaders(request);
    }

    protected void insertAuthenticationHeaders(HttpRequest request) {
        request.getHeaders().set("X-Auth-Token", (Object)this.getDnsapi().requestToken());
    }

    protected void interceptResponse(HttpResponse response) throws DNSAPIException, IOException {
        this.handleExceptionIfNeeded(response);
    }

    protected void handleExceptionIfNeeded(HttpResponse response) throws DNSAPIException, IOException {
        int statusCode = response.getStatusCode();
        if (statusCode / 100 == 2) {
            return;
        }
        if (statusCode / 100 == 4 || statusCode / 100 == 5) {
            String responseAsString = response.parseAsString();
            if (responseAsString == null || !responseAsString.startsWith("{")) {
                throw new DNSAPIException("Unknown error in DNS API: " + responseAsString);
            }
            DNSAPIRoot responseObj = this.parse(responseAsString, (Type)((Object)ErrorMessage.class));
            ErrorMessage errorMsg = (ErrorMessage)responseObj.getFirstObject();
            if (errorMsg != null && errorMsg.getMsg() != null) {
                throw new DNSAPIException(errorMsg.getMsg());
            }
            throw new DNSAPIException(responseAsString);
        }
        throw new DNSAPIException(response.parseAsString());
    }

    protected <E> DNSAPIRoot<E> parse(String responseAsString, Type type) throws DNSAPIException {
        try {
            DNSAPIRoot dnsAPIRoot = new DNSAPIRoot();
            if ("".equalsIgnoreCase(responseAsString)) {
                return dnsAPIRoot;
            }
            boolean isList = false;
            if (responseAsString.startsWith("[") && responseAsString.endsWith("]")) {
                isList = true;
            }
            StringReader in = new StringReader(responseAsString);
            if (isList) {
                List retList = (List)parser.parseAndClose((Reader)in, type);
                dnsAPIRoot.setObjectList(retList);
            } else {
                Object retObj = parser.parseAndClose((Reader)in, type);
                dnsAPIRoot.getObjectList().add(retObj);
            }
            return dnsAPIRoot;
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e.getMessage(), e);
        }
    }

    protected <E> DNSAPIRoot<E> parse(HttpResponse response, Type type) throws DNSAPIException {
        try {
            return this.parse(response.parseAsString(), type);
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e.getMessage(), e);
        }
    }

    protected GenericUrl buildUrl(String suffixUrl) {
        return new GenericUrl(this.dnsapi.getBaseUrl() + suffixUrl);
    }

    protected DNSAPIRoot<T> get(String suffixUrl, boolean returnsList) throws DNSAPIException {
        try {
            Type type = returnsList ? this.getListType() : this.getType();
            GenericUrl url = this.buildUrl(suffixUrl);
            HttpRequest request = this.requestFactory.buildGetRequest(url);
            HttpResponse response = request.execute();
            return this.parse(response, type);
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e, e);
        }
    }

    protected DNSAPIRoot<T> post(String suffixUrl, Object payload, boolean returnsList) throws DNSAPIException {
        try {
            Type type = returnsList ? this.getListType() : this.getType();
            GenericUrl url = this.buildUrl(suffixUrl);
            JsonHttpContent content = null;
            if (payload != null) {
                content = new JsonHttpContent(JSON_FACTORY, payload);
            }
            HttpRequest request = this.requestFactory.buildPostRequest(url, content);
            HttpResponse response = request.execute();
            return this.parse(response, type);
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e, e);
        }
    }

    protected DNSAPIRoot<T> put(String suffixUrl, Object payload, boolean returnsList) throws DNSAPIException {
        try {
            Type type = returnsList ? this.getListType() : this.getType();
            GenericUrl url = this.buildUrl(suffixUrl);
            JsonHttpContent content = null;
            if (payload != null) {
                content = new JsonHttpContent(JSON_FACTORY, payload);
            }
            HttpRequest request = this.requestFactory.buildPutRequest(url, content);
            HttpResponse response = request.execute();
            return this.parse(response, type);
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e, e);
        }
    }

    protected DNSAPIRoot<T> delete(String suffixUrl, boolean returnsList) throws DNSAPIException {
        try {
            Type type = returnsList ? this.getListType() : this.getType();
            GenericUrl url = this.buildUrl(suffixUrl);
            HttpRequest request = this.requestFactory.buildDeleteRequest(url);
            HttpResponse response = request.execute();
            return this.parse(response, type);
        }
        catch (IOException e) {
            throw new DNSAPIException("IOError: " + e, e);
        }
    }
}

