/*
 * Decompiled with CFR 0.152.
 */
package com.globo.dnsapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.globo.dnsapi.AbstractAPI;
import com.globo.dnsapi.DNSAPI;
import com.globo.dnsapi.DNSAPIException;
import com.globo.dnsapi.model.DNSAPIRoot;
import com.globo.dnsapi.model.Record;
import java.lang.reflect.Type;
import java.util.List;

public class RecordAPI
extends AbstractAPI<Record> {
    public RecordAPI(DNSAPI transport) {
        super(transport);
    }

    @Override
    protected Type getType() {
        return new TypeReference<Record>(){}.getType();
    }

    @Override
    protected Type getListType() {
        return new TypeReference<List<Record>>(){}.getType();
    }

    public Record createRecord(Long domainId, String name, String content, String type) throws DNSAPIException {
        if (domainId == null) {
            throw new DNSAPIException("Domain id cannot be null");
        }
        Record record = new Record();
        record.getGenericRecordAttributes().setDomainId(domainId);
        record.getGenericRecordAttributes().setName(name);
        record.getGenericRecordAttributes().setContent(content);
        record.getGenericRecordAttributes().setType(type.toUpperCase());
        DNSAPIRoot dnsAPIRoot = this.post("/domains/" + domainId + "/records.json", record, false);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid response");
        }
        return (Record)dnsAPIRoot.getFirstObject();
    }

    public List<Record> listAll(Long domainId) throws DNSAPIException {
        if (domainId == null) {
            throw new DNSAPIException("Domain id cannot be null");
        }
        DNSAPIRoot dnsAPIRoot = this.get("/domains/" + domainId + "/records.json", true);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid response");
        }
        return dnsAPIRoot.getObjectList();
    }

    public List<Record> listByQuery(Long domainId, String query) throws DNSAPIException {
        if (domainId == null) {
            throw new DNSAPIException("Domain id cannot be null");
        }
        if (query == null) {
            throw new DNSAPIException("Query cannot be null");
        }
        DNSAPIRoot dnsAPIRoot = this.get("/domains/" + domainId + "/records.json?query=" + query, true);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid response");
        }
        return dnsAPIRoot.getObjectList();
    }

    public Record getById(Long recordId) throws DNSAPIException {
        if (recordId == null) {
            throw new DNSAPIException("Record id cannot be null");
        }
        DNSAPIRoot dnsAPIRoot = this.get("/records/" + recordId + ".json", false);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid response");
        }
        return (Record)dnsAPIRoot.getFirstObject();
    }

    public void updateRecord(Long recordId, Long domainId, String name, String content) throws DNSAPIException {
        DNSAPIRoot dnsAPIRoot;
        if (recordId == null) {
            throw new DNSAPIException("Record id cannot be null");
        }
        Record record = new Record();
        if (domainId != null) {
            record.getGenericRecordAttributes().setDomainId(domainId);
        }
        if (name != null) {
            record.getGenericRecordAttributes().setName(name);
        }
        if (content != null) {
            record.getGenericRecordAttributes().setContent(content);
        }
        if ((dnsAPIRoot = this.put("/records/" + recordId + ".json", record, false)) == null) {
            throw new DNSAPIException("Invalid response");
        }
    }

    public void removeRecord(Long recordId) throws DNSAPIException {
        if (recordId == null) {
            throw new DNSAPIException("Record id cannot be null");
        }
        DNSAPIRoot dnsAPIRoot = this.delete("/records/" + recordId + ".json", false);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid response");
        }
    }
}

