/*
 * Decompiled with CFR 0.152.
 */
package com.globo.dnsapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.globo.dnsapi.AbstractAPI;
import com.globo.dnsapi.DNSAPI;
import com.globo.dnsapi.DNSAPIException;
import com.globo.dnsapi.model.Authentication;
import com.globo.dnsapi.model.DNSAPIRoot;
import com.globo.dnsapi.model.User;
import com.google.api.client.http.HttpRequest;
import java.lang.reflect.Type;
import java.util.List;

public class AuthAPI
extends AbstractAPI<Authentication> {
    public AuthAPI(DNSAPI transport) {
        super(transport);
    }

    @Override
    protected Type getType() {
        return new TypeReference<Authentication>(){}.getType();
    }

    @Override
    protected Type getListType() {
        return new TypeReference<List<Authentication>>(){}.getType();
    }

    @Override
    protected void interceptRequest(HttpRequest request) {
        request.setUnsuccessfulResponseHandler(null);
    }

    public Authentication signIn(String email, String password) throws DNSAPIException {
        User user = new User(email, password);
        DNSAPIRoot payload = new DNSAPIRoot();
        payload.set("user", (Object)user);
        DNSAPIRoot dnsAPIRoot = this.post("/users/sign_in.json", (Object)payload, false);
        if (dnsAPIRoot == null) {
            throw new DNSAPIException("Invalid authentication response");
        }
        Authentication auth = (Authentication)((Object)dnsAPIRoot.getFirstObject());
        return auth;
    }
}

