/*
 * Decompiled with CFR 0.152.
 */
package com.globalpayments.android.sdk.utils;

import android.text.Editable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import java.util.Arrays;
import java.util.List;

public class ViewUtils {
    public static void handleViewVisibility(View view, boolean show) {
        view.setVisibility(show ? 0 : 8);
    }

    public static void handleViewsVisibility(boolean show, View ... views) {
        for (View view : views) {
            ViewUtils.handleViewVisibility(view, show);
        }
    }

    public static void showView(View view) {
        view.setVisibility(0);
    }

    public static void hideView(View view) {
        view.setVisibility(8);
    }

    public static void hideViews(View ... views) {
        for (View view : views) {
            ViewUtils.hideView(view);
        }
    }

    public static void showViews(View ... views) {
        for (View view : views) {
            ViewUtils.showView(view);
        }
    }

    public static String getEditTextValue(EditText editText) {
        Editable text = editText.getText();
        return text == null ? "" : text.toString();
    }

    public static void hideAllViewsExcluding(ViewGroup viewGroup, View ... views) {
        List<View> visibleViews = Arrays.asList(views);
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            boolean show = visibleViews.contains(child);
            ViewUtils.handleViewVisibility(child, show);
        }
    }
}

