/*
 * Decompiled with CFR 0.152.
 */
package com.globalpayments.android.sdk.utils;

import com.global.api.entities.exceptions.GatewayException;
import java.math.BigDecimal;

public class Utils {
    public static boolean isNullOrBlank(String value) {
        return Utils.isNull(value) || value.trim().equals("");
    }

    public static boolean isNotNullOrBlank(String value) {
        return !Utils.isNullOrBlank(value);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean areAllNotNull(Object ... objects) {
        for (Object object : objects) {
            if (!Utils.isNull(object)) continue;
            return false;
        }
        return true;
    }

    public static String getAmount(BigDecimal amount) {
        if (Utils.isNotNull(amount)) {
            return String.valueOf(amount.divide(new BigDecimal(100)));
        }
        return "";
    }

    public static Integer safeParseInt(String string) {
        Integer integer = null;
        try {
            if (Utils.isNotNullOrBlank(string)) {
                integer = Integer.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return integer;
    }

    public static BigDecimal safeParseBigDecimal(String string) {
        BigDecimal bigDecimal = null;
        try {
            if (Utils.isNotNullOrBlank(string)) {
                bigDecimal = new BigDecimal(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bigDecimal;
    }

    public static String safeParseBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal == null ? "" : bigDecimal.toString();
    }

    public static String getExceptionDescription(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder().append("Exception thrown").append("\n\nError message:\n").append(exception.getMessage());
        Throwable cause = exception.getCause();
        if (cause != null) {
            stringBuilder.append("\n\nError cause:\n").append(cause);
        }
        if (exception instanceof GatewayException) {
            String responseText;
            GatewayException gatewayException = (GatewayException)exception;
            String responseCode = gatewayException.getResponseCode();
            if (Utils.isNotNullOrBlank(responseCode)) {
                stringBuilder.append("\n\nResponse code:\n").append(responseCode);
            }
            if (Utils.isNotNullOrBlank(responseText = gatewayException.getResponseText())) {
                stringBuilder.append("\n\nResponse text:\n").append(responseText);
            }
        }
        return stringBuilder.toString();
    }
}

