/*
 * Decompiled with CFR 0.152.
 */
package com.globalpayments.android.sdk.utils;

import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final String TAG = "FileUtils";
    public static final int BUFFER_SIZE = 8192;
    public static final int END_OF_FILE = -1;

    public static byte[] readIntoByteArray(InputStream inputStream) {
        byte[] byteArray = null;
        try {
            byteArray = new byte[inputStream.available()];
            inputStream.read(byteArray);
        }
        catch (IOException e) {
            try {
                Log.d((String)TAG, (String)("Read into byte array failed: " + e));
            }
            catch (Throwable throwable) {
                FileUtils.closeCloseables(inputStream);
                throw throwable;
            }
            FileUtils.closeCloseables(inputStream);
        }
        FileUtils.closeCloseables(inputStream);
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeByteArrayToFile(byte[] byteArray, File file) {
        boolean isWriteSuccessful = false;
        if (byteArray == null || file == null) {
            return isWriteSuccessful;
        }
        FileUtils.deleteFile(file);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            ((OutputStream)outputStream).write(byteArray);
            outputStream.flush();
            isWriteSuccessful = true;
        }
        catch (IOException e) {
            try {
                Log.d((String)TAG, (String)("Write byte array to file failed: " + e));
            }
            catch (Throwable throwable) {
                FileUtils.closeCloseables(outputStream);
                throw throwable;
            }
            FileUtils.closeCloseables(outputStream);
        }
        FileUtils.closeCloseables(outputStream);
        return isWriteSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeByteArrayToOutputStream(byte[] byteArray, OutputStream outputStream) {
        boolean isWriteSuccessful = false;
        if (byteArray == null || outputStream == null) {
            return isWriteSuccessful;
        }
        try {
            outputStream.write(byteArray);
            outputStream.flush();
            isWriteSuccessful = true;
        }
        catch (IOException e) {
            try {
                Log.d((String)TAG, (String)("Write byte array to OutputStream failed: " + e));
            }
            catch (Throwable throwable) {
                FileUtils.closeCloseables(outputStream);
                throw throwable;
            }
            FileUtils.closeCloseables(outputStream);
        }
        FileUtils.closeCloseables(outputStream);
        return isWriteSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStreamToFile(InputStream inputStream, File file) {
        boolean isWriteSuccessful = false;
        if (inputStream == null || file == null) {
            return isWriteSuccessful;
        }
        FileUtils.deleteFile(file);
        FileOutputStream outputStream = null;
        try {
            int chunk;
            byte[] buffer = new byte[8192];
            outputStream = new FileOutputStream(file);
            while ((chunk = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, chunk);
            }
            outputStream.flush();
            isWriteSuccessful = true;
        }
        catch (IOException e) {
            try {
                Log.d((String)TAG, (String)("Write stream to file failed: " + e));
            }
            catch (Throwable throwable) {
                FileUtils.closeCloseables(inputStream, outputStream);
                throw throwable;
            }
            FileUtils.closeCloseables(inputStream, outputStream);
        }
        FileUtils.closeCloseables(inputStream, outputStream);
        return isWriteSuccessful;
    }

    public static void closeCloseables(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)("Close stream failed: " + e));
            }
        }
    }

    public static void deleteFile(File file) {
        try {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        catch (SecurityException e) {
            Log.d((String)TAG, (String)("Delete file failed: " + e));
        }
    }

    public static boolean isFileReadable(File file) {
        return file != null && file.exists() && file.canRead() && file.length() > 0L;
    }
}

