/*
 * Decompiled with CFR 0.152.
 */
package com.globalpayments.android.sdk.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContextUtils {
    private static final String TAG = "ContextUtils";

    public static String getFileNameFromUri(Uri uri, Context context) {
        String fileName = "";
        try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);){
            if (cursor != null && cursor.moveToFirst()) {
                fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Get file name from uri failed: " + e));
        }
        return fileName;
    }

    public static InputStream getInputStreamForUri(Uri uri, Context context) {
        InputStream inputStream = null;
        try {
            inputStream = context.getContentResolver().openInputStream(uri);
        }
        catch (FileNotFoundException e) {
            Log.d((String)TAG, (String)("Open input stream failed" + e));
        }
        return inputStream;
    }

    public static OutputStream getOutputStreamForUri(Uri uri, Context context) {
        OutputStream outputStream = null;
        try {
            outputStream = context.getContentResolver().openOutputStream(uri);
        }
        catch (FileNotFoundException e) {
            Log.d((String)TAG, (String)("Open output stream failed" + e));
        }
        return outputStream;
    }

    public static boolean isExternalStorageWritable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static File getAppDocumentsDirectory(Context context) {
        return ContextUtils.getAppPrivateStoreDirectory(context, Environment.DIRECTORY_DOCUMENTS);
    }

    public static File getAppPrivateStoreDirectory(Context context, String type) {
        if (ContextUtils.isExternalStorageWritable()) {
            return context.getExternalFilesDir(type);
        }
        return context.getFilesDir();
    }
}

