/*
 * Decompiled with CFR 0.152.
 */
package com.globalpayments.android.sdk;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TaskExecutor {
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    private <T> void execute(final Task<T> task) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = task.executeAsync();
                    if (result == null) {
                        TaskExecutor.this.callOnError(task, new Exception("Null response"));
                    } else {
                        TaskExecutor.this.callOnSuccess(task, result);
                    }
                }
                catch (Exception e) {
                    TaskExecutor.this.callOnError(task, e);
                }
            }
        });
    }

    private <T> void callOnSuccess(final Task<T> task, final T result) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                task.onSuccess(result);
            }
        });
    }

    private <T> void callOnError(final Task<T> task, final Exception exception) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                task.onError(exception);
            }
        });
    }

    public static <T> void executeAsync(Task<T> task) {
        new TaskExecutor().execute(task);
    }

    public static interface Task<T> {
        public T executeAsync() throws Exception;

        public void onSuccess(T var1);

        public void onError(Exception var1);
    }
}

