/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.application;

import com.globalmentor.application.AbstractApplication;
import io.clogr.Clogr;
import io.confound.config.Configuration;
import io.confound.config.ConfigurationException;
import io.confound.config.file.AbstractFileConfigurationManager;
import io.confound.config.file.ResourcesConfigurationManager;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.event.Level;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=MetadataProvider.class, mixinStandardHelpOptions=true)
public abstract class BaseCliApplication
extends AbstractApplication {
    public static final String CONFIG_KEY_NAME = "name";
    public static final String CONFIG_KEY_VERSION = "version";
    private final Level defaultLogLevel;
    private boolean debug;
    private boolean trace;

    public String getName() {
        try {
            return ((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.getClass()).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(CONFIG_KEY_NAME);
        }
        catch (IOException ioException) {
            throw new ConfigurationException((Throwable)ioException);
        }
    }

    @Override
    public String getVersion() {
        try {
            return ((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.getClass()).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(CONFIG_KEY_VERSION);
        }
        catch (IOException ioException) {
            throw new ConfigurationException((Throwable)ioException);
        }
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @CommandLine.Option(names={"--debug", "-d"}, description={"Turns on debug mode and enables debug level logging."}, scope=CommandLine.ScopeType.INHERIT)
    protected void setDebug(boolean debug) {
        this.debug = debug;
        this.updateLogLevel();
    }

    private boolean isTrace() {
        return this.trace;
    }

    @CommandLine.Option(names={"--trace"}, description={"Enables trace level logging."}, scope=CommandLine.ScopeType.INHERIT)
    protected void setTrace(boolean trace) {
        this.trace = trace;
        this.updateLogLevel();
    }

    protected void updateLogLevel() {
        Level logLevel = this.isTrace() ? Level.TRACE : (this.isDebug() ? Level.DEBUG : this.defaultLogLevel);
        Clogr.getLoggingConcern().setLogLevel(logLevel);
    }

    public BaseCliApplication(@Nonnull String[] args) {
        this(args, Level.WARN);
    }

    public BaseCliApplication(@Nonnull String[] args, Level defaultLogLevel) {
        super(args);
        this.defaultLogLevel = defaultLogLevel;
        this.updateLogLevel();
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        AnsiConsole.systemInstall();
    }

    @Override
    protected int execute() {
        CommandLine.IExecutionExceptionHandler errorHandler = (exception, commandLine, parseResult) -> {
            this.reportError(exception);
            return 1;
        };
        return new CommandLine((Object)this).setExecutionExceptionHandler(errorHandler).execute(this.getArgs());
    }

    @Override
    public void run() {
        CommandLine.usage((Object)this, (PrintStream)System.out);
    }

    @Override
    public void exit(int status) {
        AnsiConsole.systemUninstall();
        super.exit(status);
    }

    @Override
    public void reportError(Throwable throwable) {
        this.reportError(this.toErrorMessage(throwable), throwable);
    }

    @Override
    public void reportError(@Nonnull String message, @Nonnull Throwable throwable) {
        this.reportError(message);
        this.getLogger().debug("{}", (Object)message, (Object)throwable);
    }

    @Override
    public void reportError(String message) {
        this.getLogger().error("{}", (Object)message);
    }

    protected static class MetadataProvider
    implements CommandLine.IVersionProvider {
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec commandSpec;

        protected MetadataProvider() {
        }

        public String[] getVersion() throws Exception {
            return new String[]{((Configuration)ResourcesConfigurationManager.loadConfigurationForClass(this.commandSpec.userObject().getClass()).orElseThrow(AbstractFileConfigurationManager::createConfigurationNotFoundException)).getString(BaseCliApplication.CONFIG_KEY_VERSION)};
        }
    }
}

